/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.nio;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.AbstractInput;
import kotlinx.io.core.ByteReadPacketBase;
import kotlinx.io.core.Input;
import kotlinx.io.core.IoBuffer;
import kotlinx.io.core.internal.RequireFailureCapture;
import kotlinx.io.internal.jvm.ErrorsKt;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkotlinx/io/nio/ChannelAsInput;", "Lkotlinx/io/core/AbstractInput;", "Lkotlinx/io/core/Input;", "channel", "Ljava/nio/channels/ReadableByteChannel;", "pool", "Lkotlinx/io/pool/ObjectPool;", "Lkotlinx/io/core/IoBuffer;", "(Ljava/nio/channels/ReadableByteChannel;Lkotlinx/io/pool/ObjectPool;)V", "closeSource", "", "fill", "kotlinx-io-jvm"})
final class ChannelAsInput
extends AbstractInput
implements Input {
    private final ReadableByteChannel channel;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected IoBuffer fill() {
        IoBuffer buffer = this.getPool().borrow();
        buffer.reserveEndGap(ByteReadPacketBase.Companion.getReservedSize());
        try {
            void this_$iv$iv$iv;
            void this_$iv$iv;
            boolean condition$iv$iv;
            void this_$iv;
            int rc = -1;
            IoBuffer ioBuffer = buffer;
            int size$iv = 1;
            int rem$iv = this_$iv.getWriteRemaining();
            boolean bl = condition$iv$iv = size$iv <= rem$iv;
            if (!condition$iv$iv) {
                RequireFailureCapture m$iv$iv = new RequireFailureCapture(size$iv, rem$iv){
                    final /* synthetic */ int $size$inlined;
                    final /* synthetic */ int $rem$inlined;
                    {
                        this.$size$inlined = n;
                        this.$rem$inlined = n2;
                    }

                    @NotNull
                    public Void doFail() {
                        String string;
                        String string2 = string = "size " + this.$size$inlined + " is greater than buffer's remaining capacity " + this.$rem$inlined;
                        throw (Throwable)new IllegalArgumentException(string2);
                    }
                };
                Void void_ = m$iv$iv.doFail();
                throw null;
            }
            ByteBuffer buffer$iv = this_$iv.writeBuffer;
            int positionBefore$iv = buffer$iv.position();
            ByteBuffer bb = buffer$iv;
            rc = this.channel.read(bb);
            int delta$iv = buffer$iv.position() - positionBefore$iv;
            if (delta$iv < 0 || delta$iv > rem$iv) {
                Void void_ = ErrorsKt.wrongBufferPositionChangeError(delta$iv, size$iv);
                throw null;
            }
            void var12_14 = this_$iv$iv = this_$iv;
            ByteBuffer byteBuffer = this_$iv$iv.readBuffer;
            int n = this_$iv$iv$iv.writeBuffer.position();
            byteBuffer.limit(n);
            if (rc == -1) {
                buffer.release(this.getPool());
                return null;
            }
            return buffer;
        }
        catch (Throwable t) {
            buffer.release(this.getPool());
            throw t;
        }
    }

    @Override
    protected void closeSource() {
        this.channel.close();
    }

    public ChannelAsInput(@NotNull ReadableByteChannel channel, @NotNull ObjectPool<IoBuffer> pool) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull(pool, (String)"pool");
        super(null, 0L, pool, 3, null);
        this.channel = channel;
        boolean bl2 = bl = !(this.channel instanceof SelectableChannel) || !((SelectableChannel)((Object)this.channel)).isBlocking();
        if (!bl) {
            String string = "Non-blocking channels are not supported";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }
}

