/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.openstreetmap.josm.tools.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class XmlObjectParser
implements Iterable<Object> {
    public static final String lang = LanguageInfo.getLanguageCodeXML();
    private final Map<String, Entry> mapping = new HashMap<String, Entry>();
    private final DefaultHandler parser;
    private final List<Object> queue = new LinkedList<Object>();
    private Iterator<Object> queueIterator;

    public XmlObjectParser() {
        this.parser = new Parser();
    }

    private Iterable<Object> start(Reader in, ContentHandler contentHandler) throws SAXException, IOException {
        try {
            XMLReader reader = XmlUtils.newSafeSAXParser().getXMLReader();
            reader.setContentHandler(contentHandler);
            try {
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXException e) {
                Logging.log(Logging.LEVEL_ERROR, "Cannot disable 'load-external-dtd' feature:", e);
            }
            reader.parse(new InputSource(in));
            this.queueIterator = this.queue.iterator();
            return this;
        }
        catch (ParserConfigurationException e) {
            throw new JosmRuntimeException(e);
        }
    }

    public Iterable<Object> start(Reader in) throws SAXException {
        try {
            return this.start(in, this.parser);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public Iterable<Object> startWithValidation(Reader in, String namespace, String schemaSource) throws SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void map(String tagName, Class<?> klass) {
        this.mapping.put(tagName, new Entry(klass, false, false));
    }

    public void mapOnStart(String tagName, Class<?> klass) {
        this.mapping.put(tagName, new Entry(klass, true, false));
    }

    public void mapBoth(String tagName, Class<?> klass) {
        this.mapping.put(tagName, new Entry(klass, false, true));
    }

    public Object next() {
        return this.queueIterator.next();
    }

    public boolean hasNext() {
        return this.queueIterator.hasNext();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.queue.iterator();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    private static class Entry {
        private final Class<?> klass;
        private final boolean onStart;
        private final boolean both;
        private final Map<String, Field> fields = new HashMap<String, Field>();
        private final Map<String, Method> methods = new HashMap<String, Method>();

        Entry(Class<?> klass, boolean onStart, boolean both) {
            this.klass = klass;
            this.onStart = onStart;
            this.both = both;
        }

        Field getField(String s) {
            return this.fields.computeIfAbsent(s, ignore -> Arrays.stream(this.klass.getFields()).filter(f -> f.getName().equals(s)).findFirst().orElse(null));
        }

        Method getMethod(String s) {
            return this.methods.computeIfAbsent(s, ignore -> Arrays.stream(this.klass.getMethods()).filter(m -> m.getName().equals(s) && m.getParameterTypes().length == 1).findFirst().orElse(null));
        }
    }

    private class Parser
    extends DefaultHandler {
        private final Stack<Object> current = new Stack();
        private StringBuilder characters = new StringBuilder(64);
        private Locator locator;

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(Exception e) throws XmlParsingException {
            throw new XmlParsingException(e).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String ns, String lname, String qname, Attributes a) throws SAXException {
            Entry entry = (Entry)XmlObjectParser.this.mapping.get(qname);
            if (entry != null) {
                Class klass = entry.klass;
                try {
                    this.current.push(klass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ReflectiveOperationException e) {
                    this.throwException(e);
                }
                for (int i = 0; i < a.getLength(); ++i) {
                    this.setValue(entry, a.getQName(i), a.getValue(i));
                }
                if (entry.onStart) {
                    this.report();
                }
                if (entry.both) {
                    XmlObjectParser.this.queue.add(this.current.peek());
                }
            }
        }

        @Override
        public void endElement(String ns, String lname, String qname) throws SAXException {
            Entry entry = (Entry)XmlObjectParser.this.mapping.get(qname);
            if (entry != null && !entry.onStart) {
                this.report();
            } else if (entry != null && this.characters != null && !this.current.isEmpty()) {
                this.setValue(entry, qname, this.characters.toString().trim());
                this.characters = new StringBuilder(64);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.characters.append(ch, start, length);
        }

        private void report() {
            XmlObjectParser.this.queue.add(this.current.pop());
            this.characters = new StringBuilder(64);
        }

        private Object getValueForClass(Class<?> klass, String value) {
            if (Boolean.TYPE.equals(klass)) {
                return this.parseBoolean(value);
            }
            if (Integer.class.equals(klass)) {
                return Integer.valueOf(value);
            }
            if (Long.class.equals(klass)) {
                return Long.valueOf(value);
            }
            if (Float.class.equals(klass)) {
                return Float.valueOf(value);
            }
            if (Double.class.equals(klass)) {
                return Double.valueOf(value);
            }
            return value;
        }

        private void setValue(Entry entry, String fieldName, String value) throws SAXException {
            CheckParameterUtil.ensureParameterNotNull(entry, "entry");
            if ("class".equals(fieldName) || "default".equals(fieldName) || "throw".equals(fieldName) || "new".equals(fieldName) || "null".equals(fieldName)) {
                fieldName = fieldName + '_';
            }
            fieldName = fieldName.replace(':', '_');
            try {
                Object c = this.current.peek();
                Field f = entry.getField(fieldName);
                if (f == null && fieldName.startsWith(lang)) {
                    f = entry.getField("locale_" + fieldName.substring(lang.length()));
                }
                if (f != null && Modifier.isPublic(f.getModifiers()) && (String.class.equals(f.getType()) || Boolean.TYPE.equals(f.getType()) || Float.class.equals(f.getType()) || Double.class.equals(f.getType()) || Long.class.equals(f.getType()) || Integer.class.equals(f.getType()))) {
                    f.set(c, this.getValueForClass(f.getType(), value));
                } else {
                    String setter;
                    if (fieldName.startsWith(lang)) {
                        int l = lang.length();
                        setter = "set" + fieldName.substring(l, l + 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(l + 1);
                    } else {
                        setter = "set" + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
                    }
                    Method m = entry.getMethod(setter);
                    if (m != null) {
                        m.invoke(c, this.getValueForClass(m.getParameterTypes()[0], value));
                    }
                }
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                Logging.error(e);
                this.throwException(e);
            }
        }

        private boolean parseBoolean(String s) {
            return s != null && !"0".equals(s) && !s.startsWith("off") && !s.startsWith("false") && !s.startsWith("no");
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.throwException(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.throwException(e);
        }
    }

    private static class AddNamespaceFilter
    extends XMLFilterImpl {
        private final String namespace;

        AddNamespaceFilter(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("".equals(uri)) {
                super.startElement(this.namespace, localName, qName, atts);
            } else {
                super.startElement(uri, localName, qName, atts);
            }
        }
    }
}

