/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.editor.TabActivator;
import net.sf.sdedit.editor.plugin.Plugin;
import net.sf.sdedit.editor.plugin.PluginRegistry;
import net.sf.sdedit.help.HelpTab;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.Tab;
import net.sf.sdedit.ui.TabListener;
import net.sf.sdedit.ui.UserInterface;
import net.sf.sdedit.ui.UserInterfaceListener;
import net.sf.sdedit.ui.components.GrabbableViewport;
import net.sf.sdedit.ui.components.MenuBar;
import net.sf.sdedit.ui.components.ScalePanel;
import net.sf.sdedit.ui.components.ToolBar;
import net.sf.sdedit.ui.components.buttons.ActionManager;
import net.sf.sdedit.ui.components.buttons.Activator;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.ConfigurationAction;
import net.sf.sdedit.ui.components.configuration.ConfigurationUIListener;
import net.sf.sdedit.ui.impl.AboutDialog;
import net.sf.sdedit.ui.impl.DiagramTab;
import net.sf.sdedit.ui.impl.PreferencesUI;
import net.sf.sdedit.ui.impl.PrintDialog;
import net.sf.sdedit.ui.impl.SequenceDiagramTextTab;
import net.sf.sdedit.ui.impl.TabContainer;
import net.sf.sdedit.ui.impl.TabContainerListener;
import net.sf.sdedit.ui.impl.TabNavigatorContainer;
import net.sf.sdedit.util.FileDrop;
import net.sf.sdedit.util.OS;
import net.sf.sdedit.util.Predicate;
import net.sf.sdedit.util.UIUtilities;

public final class UserInterfaceImpl
extends JFrame
implements Constants,
UserInterface,
TabContainerListener,
HyperlinkListener,
ConfigurationUIListener,
TabListener,
FileDrop.Listener {
    private TabContainer tabContainer;
    private JPanel bottomPanel;
    private MenuBar menuBar;
    private List<UserInterfaceListener> listeners;
    private ScalePanel scalePanel;
    private PrintDialog printDialog;
    private ToolBar toolbar;
    private PreferencesUI prefUI;
    private Timer timer;
    private Map<Runnable, TimerTask> timerTasks;
    private final TabActivator<Tab> zoomActivator = new TabActivator<Tab>(Tab.class, (UserInterface)this){

        @Override
        protected boolean _isEnabled(Tab tab) {
            return tab.canZoom();
        }
    };

    @Override
    public void showAboutDialog(URL aboutURL) {
        System.gc();
        new AboutDialog(this, aboutURL, "About Quick Sequence Diagram Editor").setVisible(true);
    }

    private ActionManager actionManager() {
        return Editor.getEditor().getActionManager();
    }

    public ToolBar getToolbar() {
        return this.toolbar;
    }

    public UserInterfaceImpl() {
        this.setDefaultCloseOperation(0);
        this.prefUI = new PreferencesUI(this);
        this.listeners = new LinkedList<UserInterfaceListener>();
        this.menuBar = new MenuBar();
        this.toolbar = new ToolBar();
        this.toolbar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.toolbar.setFloatable(false);
        new FileDrop(this, this);
        this.timer = new Timer(true);
        this.timerTasks = new IdentityHashMap<Runnable, TimerTask>();
    }

    public void addTask(final Runnable task, int period) {
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                task.run();
            }
        };
        this.timerTasks.put(task, tt);
        this.timer.schedule(tt, 0L, (long)period);
    }

    public void removeTask(Runnable task) {
        TimerTask tt = this.timerTasks.get(task);
        if (tt != null) {
            tt.cancel();
        }
    }

    @Override
    public void addListener(UserInterfaceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addCategory(String category, String icon) {
        ImageIcon imageIcon = icon == null || icon.equals("") ? null : Icons.getIcon(icon);
        this.menuBar.addMenu(category, imageIcon);
    }

    @Override
    public void addAction(String category, Action action, Activator activator) {
        String iconName;
        if (action != null && (iconName = (String)(action = this.actionManager().addAction(action)).getValue("IconName")) != null) {
            ImageIcon icon = Icons.getIcon(iconName);
            action.putValue("SmallIcon", icon);
        }
        JMenuItem item = this.menuBar.addAction(category, action, -1);
        this.registerComponent(item, action, activator);
    }

    @Override
    public void addConfigurationAction(String category, ConfigurationAction<?> action, Activator activator) {
        JCheckBoxMenuItem item = MenuBar.makeMenuItem(action.getValue("Name").toString(), JCheckBoxMenuItem.class);
        this.menuBar.addItem(category, item);
        item.setToolTipText(action.getValue("ShortDescription").toString());
        item.setIcon((Icon)action.getValue("SmallIcon"));
        this.registerComponent(item, action, activator);
        item.addActionListener(action);
        this.actionManager().registerConfigurationAction(action, item);
    }

    void registerComponent(JComponent comp, Action action, Activator activator) {
        this.actionManager().registerButton(comp, action, activator);
    }

    public void enableComponents() {
        this.actionManager().enableComponents();
    }

    @Override
    public void help(String title, String file, boolean advanced) {
        HelpTab tab;
        if (!this.tabContainer.existsCategory("Help pages")) {
            this.tabContainer.addCategory("Help pages", Icons.getIcon("help"));
        }
        if (this.tabContainer.exists(tab = HelpTab.getHelpTab(this, file, advanced))) {
            this.tabContainer.select(tab);
        } else {
            tab.setTitle(title);
            this.tabContainer.addTab(tab, true);
        }
    }

    public void fireHyperlinkClicked(String hyperlink) {
        for (UserInterfaceListener listener : this.listeners) {
            listener.hyperlinkClicked(hyperlink);
        }
    }

    @Override
    public void showUI() {
        this.setIconImage(Icons.getIcon("icon").getImage());
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.tabContainer = new TabNavigatorContainer(0.2);
        this.tabContainer.addCategory("Sequence diagrams", Icons.getIcon("text"));
        for (Plugin plugin : PluginRegistry.getInstance()) {
            if (plugin.getCategory() == null) continue;
            this.tabContainer.addCategory(plugin.getCategory(), plugin.getIcon());
        }
        this.tabContainer.addListener(this);
        pane.add((Component)this.tabContainer.getComponent(), "Center");
        pane.add((Component)this.toolbar, "North");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.scalePanel = new ScalePanel(false);
        Dimension spSize = new Dimension(140, 24);
        this.scalePanel.setMaximumSize(spSize);
        this.scalePanel.setMinimumSize(spSize);
        this.scalePanel.setPreferredSize(spSize);
        this.scalePanel.setOpaque(false);
        this.addToolbarSeparator();
        this.toolbar.add(this.scalePanel);
        this.registerComponent(this.scalePanel, null, this.zoomActivator);
        this.addToolbarSeparator();
        this.addToToolbar(this.scalePanel.normalSizeAction, this.zoomActivator);
        this.addToToolbar(this.scalePanel.fitHeightAction, this.zoomActivator);
        this.addToToolbar(this.scalePanel.fitWidthAction, this.zoomActivator);
        this.addToToolbar(this.scalePanel.fitWindowAction, this.zoomActivator);
        pane.add((Component)this.bottomPanel, "South");
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int width = (int)(0.8 * (double)screenWidth);
        int height = (int)(0.8 * (double)screenHeight);
        int left = (int)(0.1 * (double)screenWidth);
        int top = (int)(0.1 * (double)screenHeight);
        this.setSize(width, height);
        this.setLocation(left, top);
        this.setJMenuBar(this.menuBar);
        ConfigurationManager.getGlobalConfigurationBean().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                UserInterfaceImpl.this.enableComponents();
                if (evt.getPropertyName().equals("tooltipDismissDelay")) {
                    ToolTipManager.sharedInstance().setDismissDelay(ConfigurationManager.getGlobalConfiguration().getTooltipDismissDelay() * 1000);
                }
            }
        });
        this.enableComponents();
        this.setTitle("Quick Sequence Diagram Editor");
        this.setVisible(true);
    }

    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public String addTab(Tab tab, boolean selectIt) {
        String name = this.tabContainer.addTab(tab, selectIt);
        this.enableComponents();
        return name;
    }

    @Override
    public Tab addSequenceDiagramTextTab(String tabTitle, Bean<SequenceConfiguration> configuration, boolean selectIt) {
        SequenceDiagramTextTab tab = new SequenceDiagramTextTab(this, ConfigurationManager.getGlobalConfiguration().getEditorFont(), configuration);
        tab.setTitle(tabTitle);
        this.addTab(tab, selectIt);
        return tab;
    }

    @Override
    public Tab currentTab() {
        return this.tabContainer.getSelectedTab();
    }

    public void updateToolbarAction(Action action) {
        this.toolbar.updateAction(action);
    }

    @Override
    public File getCurrentFile() {
        return this.currentTab().getFile();
    }

    @Override
    public boolean closeCurrentTab(boolean check) {
        boolean flag = this.currentTab().close(check);
        this.enableComponents();
        return flag;
    }

    @Override
    public void addToToolbar(Action _action, Activator activator) {
        Action action = this.actionManager().addAction(_action);
        JButton button = this.toolbar.addAction(action);
        this.registerComponent(button, action, activator);
    }

    @Override
    public void addToolbarSeparator() {
        this.toolbar.addSeparator();
    }

    @Override
    public void configure(Bean<? extends Configuration> conf) {
        this.prefUI.configure(conf);
    }

    @Override
    public void setQuitAction(final Action action) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                action.actionPerformed(new ActionEvent(this, 1001, ""));
            }
        });
    }

    @Override
    public int confirmOrCancel(String message) {
        String option = this.getOption(message, "Cancel", "No", "Yes#");
        switch (option.charAt(0)) {
            case 'Y': {
                return 1;
            }
            case 'N': {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public boolean confirm(String message) {
        return this.confirmOrCancel(message) == 1;
    }

    @Override
    public void message(String msg) {
        JOptionPane.showMessageDialog(this, msg);
    }

    @Override
    public int getNumberOfTabs() {
        return this.tabContainer.getTabCount();
    }

    @Override
    public String getString(String question, String initialValue) {
        return JOptionPane.showInputDialog(this, question, initialValue);
    }

    public void addPredicateAction(String category, String name, String description, String tooltip, Icon icon, Predicate predicate, boolean initialValue) {
        this.menuBar.addToggleAction(category, name, description, tooltip, icon, predicate, initialValue);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (event.getURL().toString().startsWith("http")) {
                return;
            }
            if (event.getURL().toString().endsWith("sdx")) {
                String file = event.getURL().toString();
                file = file.substring(file.lastIndexOf(47) + 1);
                this.fireHyperlinkClicked("example:" + file);
            } else if (event.getURL().toString().indexOf(35) > 0) {
                try {
                    JEditorPane pane = (JEditorPane)event.getSource();
                    pane.setPage(event.getURL());
                }
                catch (Exception pane) {}
            } else if (event.getURL().toString().endsWith("html")) {
                String file = event.getURL().toString();
                file = file.substring(file.lastIndexOf(47) + 1);
                this.fireHyperlinkClicked("help:" + file);
            }
        }
    }

    @Override
    public void removeAction(String category, Action action) {
        this.menuBar.removeAction(category, action);
    }

    @Override
    public boolean selectTabWith(File file) {
        if (file != null) {
            for (Tab tab : this.tabContainer.getTabs()) {
                if (!file.equals(tab.getFile())) continue;
                this.tabContainer.select(tab);
                return true;
            }
        }
        return false;
    }

    public void selectTabById(int id) {
        for (Tab tab : this.tabContainer.getTabs()) {
            if (tab.getId() != id) continue;
            this.tabContainer.select(tab);
            return;
        }
    }

    @Override
    public boolean selectTab(Tab tab) {
        return this.tabContainer.select(tab);
    }

    @Override
    public void showPrintDialog(String filetype, DiagramTab tab) {
        if (this.printDialog == null) {
            this.printDialog = new PrintDialog(this);
        }
        this.printDialog.show(tab, filetype);
    }

    @Override
    public void exit() {
        this.setVisible(false);
    }

    public ScalePanel getScalePanel() {
        return this.scalePanel;
    }

    @Override
    public String getOption(String text, String ... options) {
        return UIUtilities.getOption(this, text, options);
    }

    @Override
    public void applyConfiguration() {
        this.prefUI.applyConfiguration();
    }

    @Override
    public void cancelConfiguration() {
        this.prefUI.cancelConfiguration();
    }

    @Override
    public void errorMessage(Throwable throwable, String caption, String header) {
        String message;
        String _caption = caption == null ? "Error" : caption;
        String string = message = header == null ? "" : header;
        if (throwable != null) {
            throwable.printStackTrace();
            if (message.length() > 0) {
                message = message + "\n\n";
            }
            message = message + "An exception of type " + throwable.getClass().getSimpleName() + "\n";
            message = message + "has occurred with the message:\n";
            message = message + throwable.getMessage();
            if (throwable.getCause() != null) {
                message = message + "\n\nThe exception was caused by a " + throwable.getCause().getClass().getSimpleName();
                message = message + "\nwith the message " + throwable.getCause().getMessage();
            }
        }
        JOptionPane.showMessageDialog(this, message, _caption, 0);
    }

    @Override
    public void addDefaultTab() {
        this.addSequenceDiagramTextTab("untitled", ConfigurationManager.createNewDefaultConfiguration(SequenceConfiguration.class), true);
    }

    @Override
    public void tabIsClosed(Tab tab) {
        this.tabContainer.remove(tab);
        if (this.tabContainer.getTabCount() == 0) {
            this.addDefaultTab();
        }
    }

    public void tabClosing(Tab tab) {
    }

    @Override
    public void tabSelected(Tab previous, Tab current) {
        Action closeAction = this.menuBar.getActionByName("[F12]&Close");
        if (closeAction != null) {
            closeAction.setEnabled(this.tabContainer.getTabCount() > 1);
        }
        for (UserInterfaceListener listener : this.listeners) {
            listener.tabChanged(previous, current);
        }
        if (current.getZoomPane() != null) {
            this.scalePanel.setScalable(current.getZoomPane());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserInterfaceImpl.this.enableComponents();
                String title = UserInterfaceImpl.this.tabContainer.getSelectedTab().getTitle();
                if (title == null) {
                    UserInterfaceImpl.this.setTitle("Quick Sequence Diagram Editor");
                } else {
                    UserInterfaceImpl.this.setTitle(title + " - Quick Sequence Diagram Editor");
                }
            }
        });
    }

    @Override
    public TabContainer getTabContainer() {
        return this.tabContainer;
    }

    @Override
    public void titleChanged(Tab tab) {
        this.setTitle(tab.getTitle() + " - Quick Sequence Diagram Editor");
    }

    @Override
    public void filesDropped(File[] files) {
        for (File file : files) {
            try {
                Editor.getEditor().load(file.toURI().toURL());
            }
            catch (IOException e) {
                this.errorMessage(e, null, null);
            }
            catch (URISyntaxException e) {
                this.errorMessage(e, null, null);
            }
        }
    }

    static {
        if (OS.TYPE != OS.Type.WINDOWS) {
            GrabbableViewport.setHandCursorIcon(Icons.getIcon("grabbing"));
        }
        ToolTipManager.sharedInstance().setDismissDelay(1000 * ConfigurationManager.getGlobalConfiguration().getTooltipDismissDelay());
    }
}

