/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.ui.DataSourceCaption;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.uisupport.UISupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.openide.awt.TabbedPaneFactory;

class DataSourceWindowTabbedPane
extends JPanel {
    private final JTabbedPane tabpane = TabbedPaneFactory.createCloseButtonTabbedPane();

    private static boolean isWindows10() {
        String osName = System.getProperty("os.name");
        return osName.indexOf("Windows 10") >= 0 || osName.equals("Windows NT (unknown)") && "10.0".equals(System.getProperty("os.version"));
    }

    private static boolean isWindowsXPLaF() {
        Boolean isXP = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return DataSourceWindowTabbedPane.isWindowsLaF() && isXP != null && isXP != false;
    }

    private static boolean isWindowsLaF() {
        String lfID = UIManager.getLookAndFeel().getID();
        return lfID.endsWith("Windows");
    }

    DataSourceWindowTabbedPane() {
        super(new BorderLayout());
        this.tabpane.setTabLayoutPolicy(0);
        this.tabpane.setFocusCycleRoot(false);
        this.tabpane.setOpaque(false);
        if (UIManager.getLookAndFeel().getID().equals("Aqua")) {
            this.tabpane.setBorder(BorderFactory.createEmptyBorder(0, -11, -13, -10));
        } else {
            this.tabpane.setBorder(BorderFactory.createEmptyBorder());
            Insets i = UIManager.getInsets("TabbedPane.contentBorderInsets");
            if (i != null) {
                this.tabpane.setBorder(BorderFactory.createEmptyBorder(0, -i.left, -i.bottom, -i.right));
            }
        }
        this.add((Component)this.tabpane, "Center");
    }

    @Override
    public final boolean requestFocusInWindow() {
        Component sel = this.tabpane.getSelectedComponent();
        if (sel != null) {
            return sel.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public void addView(DataSource dataSource, DataSourceView view) {
        ViewContainer container = new ViewContainer(new DataSourceCaption<DataSource>(dataSource), view);
        String viewName = view.getName();
        if (view.isClosable()) {
            if (viewName.indexOf("</html>") == -1) {
                viewName = viewName + " ";
            } else {
                viewName.replace("</html>", "&nbsp;</html>");
            }
        }
        this.tabpane.addTab(viewName, new ImageIcon(view.getImage()), container);
    }

    public void removeView(int index) {
        ViewContainer container = (ViewContainer)this.tabpane.getComponentAt(index);
        this.tabpane.removeTabAt(index);
        container.getCaption().finish();
    }

    public DataSourceView getView(ViewContainer container) {
        return container.getView();
    }

    public int indexOfView(final DataSourceView view) {
        final int[] index = new int[]{-1};
        UISupport.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < DataSourceWindowTabbedPane.this.tabpane.getTabCount(); ++i) {
                    if (((ViewContainer)DataSourceWindowTabbedPane.this.tabpane.getComponentAt(i)).getViewComponent() != view.getView()) continue;
                    index[0] = i;
                }
            }
        });
        return index[0];
    }

    public List<DataSourceView> getViews() {
        ArrayList<DataSourceView> views = new ArrayList<DataSourceView>();
        for (int i = 0; i < this.tabpane.getTabCount(); ++i) {
            ViewContainer container = (ViewContainer)this.tabpane.getComponentAt(i);
            views.add(container.getView());
        }
        return views;
    }

    public void setViewIndex(int index) {
        this.tabpane.setSelectedIndex(index);
    }

    public void setViewBackground(int index, Color background) {
        this.tabpane.setBackgroundAt(index, background);
    }

    public void addCloseListener(PropertyChangeListener l) {
        this.tabpane.addPropertyChangeListener("close", l);
    }

    public void removeCloseListener(PropertyChangeListener l) {
        this.tabpane.removePropertyChangeListener("close", l);
    }

    public boolean isCloseEvent(PropertyChangeEvent evt) {
        return "close".equals(evt.getPropertyName());
    }

    static {
        if (DataSourceWindowTabbedPane.isWindows10() && DataSourceWindowTabbedPane.isWindowsXPLaF()) {
            UIManager.put("nb.close.tab.icon.enabled.name", "org/openide/awt/resources/win8_bigclose_enabled.png");
            UIManager.put("nb.close.tab.icon.pressed.name", "org/openide/awt/resources/win8_bigclose_pressed.png");
            UIManager.put("nb.close.tab.icon.rollover.name", "org/openide/awt/resources/win8_bigclose_rollover.png");
        }
    }

    static class ViewContainer
    extends JPanel {
        private DataSourceCaption caption;
        private DataSourceView view;
        private DataViewComponent viewComponent;

        public ViewContainer(DataSourceCaption caption, DataSourceView view) {
            Color backgroundColor = UISupport.getDefaultBackground();
            this.caption = caption;
            this.view = view;
            this.viewComponent = view.getView();
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, backgroundColor));
            this.setBackground(backgroundColor);
            this.setFocusable(false);
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                }
            });
            this.add((Component)this.viewComponent, "Center");
            if (caption != null) {
                caption.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                caption.setBackground(backgroundColor);
                this.add((Component)caption, "North");
            }
            this.putClientProperty("noCloseButton", !view.isClosable());
        }

        @Override
        public final boolean requestFocusInWindow() {
            if (this.getComponentCount() > 0) {
                return this.getComponent(0).requestFocusInWindow();
            }
            return super.requestFocusInWindow();
        }

        public DataSourceCaption getCaption() {
            return this.caption;
        }

        public DataSourceView getView() {
            return this.view;
        }

        public DataViewComponent getViewComponent() {
            return this.viewComponent;
        }
    }
}

