/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Flags
implements Cloneable,
Serializable {
    private int systemFlags;
    private HashMap userFlags;

    public Flags() {
        this.systemFlags = 0;
        this.userFlags = null;
    }

    public Flags(Flags flags) {
        this.systemFlags = flags.systemFlags;
        this.userFlags = flags.userFlags != null ? (HashMap)flags.userFlags.clone() : null;
    }

    public Flags(Flag flag) {
        this.systemFlags |= flag.flag;
        this.userFlags = null;
    }

    public Flags(String flag) {
        this.systemFlags = 0;
        this.userFlags = new HashMap(1);
        this.userFlags.put(flag.toLowerCase(), flag);
    }

    public void add(Flag flag) {
        this.systemFlags |= flag.flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String flag) {
        if (this.userFlags == null) {
            this.userFlags = new HashMap(1);
        }
        HashMap hashMap = this.userFlags;
        synchronized (hashMap) {
            this.userFlags.put(flag.toLowerCase(), flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Flags flags) {
        this.systemFlags |= flags.systemFlags;
        if (flags.userFlags != null) {
            HashMap hashMap = flags.userFlags;
            synchronized (hashMap) {
                if (this.userFlags == null) {
                    this.userFlags = new HashMap(flags.userFlags);
                } else {
                    HashMap hashMap2 = this.userFlags;
                    synchronized (hashMap2) {
                        this.userFlags.putAll(flags.userFlags);
                    }
                }
            }
        }
    }

    public void remove(Flag flag) {
        this.systemFlags &= ~flag.flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String flag) {
        if (this.userFlags != null) {
            HashMap hashMap = this.userFlags;
            synchronized (hashMap) {
                this.userFlags.remove(flag.toLowerCase());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Flags flags) {
        this.systemFlags &= ~flags.systemFlags;
        if (this.userFlags != null && flags.userFlags != null) {
            HashMap hashMap = flags.userFlags;
            synchronized (hashMap) {
                HashMap hashMap2 = this.userFlags;
                synchronized (hashMap2) {
                    Iterator i = flags.userFlags.keySet().iterator();
                    while (i.hasNext()) {
                        this.userFlags.remove(i.next());
                    }
                }
            }
        }
    }

    public boolean contains(Flag flag) {
        return (this.systemFlags & flag.flag) != 0;
    }

    public boolean contains(String flag) {
        if (this.userFlags == null) {
            return false;
        }
        return this.userFlags.containsKey(flag.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Flags flags) {
        if ((this.systemFlags & flags.systemFlags) == 0) {
            return false;
        }
        if (flags.userFlags != null) {
            if (this.userFlags == null) {
                return false;
            }
            HashMap hashMap = this.userFlags;
            synchronized (hashMap) {
                String[] fuf = flags.getUserFlags();
                for (int i = 0; i < fuf.length; ++i) {
                    if (this.userFlags.containsKey(fuf[i].toLowerCase())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Flags)) {
            return false;
        }
        Flags flags = (Flags)other;
        if (flags.systemFlags != this.systemFlags) {
            return false;
        }
        if (flags.userFlags == null && this.userFlags == null) {
            return true;
        }
        return flags.userFlags != null && this.userFlags != null && flags.userFlags.equals(this.userFlags);
    }

    public int hashCode() {
        int hashCode = this.systemFlags;
        if (this.userFlags != null) {
            hashCode += this.userFlags.hashCode();
        }
        return hashCode;
    }

    public Flag[] getSystemFlags() {
        ArrayList acc = new ArrayList(7);
        for (Integer flag : Flag.flag2flag.keySet()) {
            if ((this.systemFlags & flag) == 0) continue;
            acc.add(Flag.flag2flag.get(flag));
        }
        Flag[] f = new Flag[acc.size()];
        acc.toArray(f);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUserFlags() {
        if (this.userFlags == null) {
            return new String[0];
        }
        HashMap hashMap = this.userFlags;
        synchronized (hashMap) {
            String[] f = new String[this.userFlags.size()];
            int index = 0;
            Iterator i = this.userFlags.keySet().iterator();
            while (i.hasNext()) {
                f[index++] = (String)this.userFlags.get(i.next());
            }
            return f;
        }
    }

    public Object clone() {
        return new Flags(this);
    }

    public static final class Flag {
        private static final HashMap flag2flag = new HashMap(7);
        public static final Flag ANSWERED = new Flag(1);
        public static final Flag DELETED = new Flag(2);
        public static final Flag DRAFT = new Flag(4);
        public static final Flag FLAGGED = new Flag(8);
        public static final Flag RECENT = new Flag(16);
        public static final Flag SEEN = new Flag(32);
        public static final Flag USER = new Flag(Integer.MIN_VALUE);
        int flag;

        private Flag(int flag) {
            this.flag = flag;
            flag2flag.put(new Integer(flag), this);
        }
    }
}

