import ts = require("./typesystem");
import { AbstractType } from "./typesystem";
import meta = require("./metainfo");
import { Annotation } from "./metainfo";
import { TypeRegistry } from "./typesystem";
import su = require('./schemaUtil');
export declare enum NodeKind {
    SCALAR = 0,
    ARRAY = 1,
    MAP = 2
}
export interface ParseNode {
    key(): string;
    value(): any;
    children(): ParseNode[];
    childWithKey(k: string): ParseNode;
    kind(): NodeKind;
    getMeta(key: string): any;
    anchor?(): any;
    path(): string;
}
export declare function parseJSON(name: string, n: any, r?: ts.TypeRegistry, provider?: su.IContentProvider): ts.AbstractType;
export declare function parseJSONTypeCollection(n: any, r?: ts.TypeRegistry, provider?: su.IContentProvider): TypeCollection;
export declare class PropertyBean {
    id: string;
    optional: boolean;
    additonal: boolean;
    regExp: boolean;
    type: ts.AbstractType;
    annotations: {
        name: string;
        key: string;
        value: any;
    }[];
    add(t: ts.AbstractType, typePath: string[]): void;
}
export declare class TypeCollection {
    private _id;
    constructor(_id: string);
    id(): string;
    private _types;
    private _typeMap;
    private uses;
    private _annotationTypes;
    private _annotationTypeMap;
    library(n: string): TypeCollection;
    addLibrary(n: string, t: TypeCollection): void;
    add(t: AbstractType): void;
    getType(name: string): ts.AbstractType;
    addAnnotationType(t: AbstractType): void;
    getAnnotationType(name: string): ts.AbstractType;
    types(): ts.AbstractType[];
    annotationTypes(): ts.AbstractType[];
    getAnnotationTypeRegistry(): TypeRegistry;
    getTypeRegistry(): TypeRegistry;
    libraries(): {
        [name: string]: TypeCollection;
    };
}
export declare class AccumulatingRegistry extends ts.TypeRegistry {
    private toParse;
    private schemas;
    private static CLASS_IDENTIFIER_AccumulatingRegistry;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is AccumulatingRegistry;
    constructor(toParse: ParseNode, schemas: ParseNode, ts: ts.TypeRegistry, _c: TypeCollection);
    parsing: {
        [name: string]: boolean;
    };
    get(name: string, isPropertyType?: boolean): ts.AbstractType;
}
export declare function parseTypes(n: any, tr?: ts.TypeRegistry): TypeCollection;
export declare function parseTypeCollection(n: ParseNode, tr: ts.TypeRegistry, ignoreUses?: boolean): TypeCollection;
export declare function parsePropertyBean(n: ParseNode, tr: ts.TypeRegistry, typePath: string[]): PropertyBean;
export declare class TypeProto {
    name: string;
    properties: PropertyBean[];
    basicFacets: ts.TypeInformation[];
    facetDeclarations: meta.FacetDeclaration[];
    annotations: Annotation[];
    customFacets: meta.CustomFacet[];
    notAScalar: boolean;
    superTypes: string[];
    additionalProperties: boolean;
    toJSON(): any;
}
export declare function toProto(type: AbstractType): TypeProto;
/***
 * stores a type to JSON structure
 * @param ts
 */
export declare function storeAsJSON(ts: AbstractType | TypeCollection): any;
/**
 * parses a type from a JSON structure
 * @param name
 * @param n
 * @param r
 * @returns {any}
 */
export declare function parse(name: string, n: ParseNode, r: ts.TypeRegistry, defaultsToAny: boolean, annotation: boolean, global: boolean, ignoreTypeAttr: boolean, isPropertyType: boolean, typePath: string[]): ts.AbstractType;
