/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk;

import java.io.File;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDiskCacheAttributes
extends AbstractAuxiliaryCacheAttributes
implements IDiskCacheAttributes {
    private static final long serialVersionUID = 8306631920391711229L;
    private static final Log log = LogFactory.getLog(AbstractDiskCacheAttributes.class);
    private File diskPath;
    private boolean allowRemoveAll = true;
    private int maxPurgatorySize = 5000;
    private static final int DEFAULT_shutdownSpoolTimeLimit = 60;
    private int shutdownSpoolTimeLimit = 60;
    private IDiskCacheAttributes.DiskLimitType diskLimitType = IDiskCacheAttributes.DiskLimitType.COUNT;

    @Override
    public void setDiskPath(String path) {
        this.setDiskPath(new File(path));
    }

    public void setDiskPath(File diskPath) {
        this.diskPath = diskPath;
        boolean result = this.diskPath.isDirectory();
        if (!result) {
            result = this.diskPath.mkdirs();
        }
        if (!result) {
            log.error("Failed to create directory " + diskPath);
        }
    }

    @Override
    public File getDiskPath() {
        return this.diskPath;
    }

    @Override
    public int getMaxPurgatorySize() {
        return this.maxPurgatorySize;
    }

    @Override
    public void setMaxPurgatorySize(int maxPurgatorySize) {
        this.maxPurgatorySize = maxPurgatorySize;
    }

    @Override
    public int getShutdownSpoolTimeLimit() {
        return this.shutdownSpoolTimeLimit;
    }

    @Override
    public void setShutdownSpoolTimeLimit(int shutdownSpoolTimeLimit) {
        this.shutdownSpoolTimeLimit = shutdownSpoolTimeLimit;
    }

    @Override
    public void setAllowRemoveAll(boolean allowRemoveAll) {
        this.allowRemoveAll = allowRemoveAll;
    }

    @Override
    public boolean isAllowRemoveAll() {
        return this.allowRemoveAll;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("AbstractDiskCacheAttributes ");
        str.append("\n diskPath = " + this.getDiskPath());
        str.append("\n maxPurgatorySize   = " + this.getMaxPurgatorySize());
        str.append("\n allowRemoveAll   = " + this.isAllowRemoveAll());
        str.append("\n ShutdownSpoolTimeLimit   = " + this.getShutdownSpoolTimeLimit());
        return str.toString();
    }

    @Override
    public void setDiskLimitType(IDiskCacheAttributes.DiskLimitType diskLimitType) {
        this.diskLimitType = diskLimitType;
    }

    @Override
    public void setDiskLimitTypeName(String diskLimitTypeName) {
        if (diskLimitTypeName != null) {
            this.diskLimitType = IDiskCacheAttributes.DiskLimitType.valueOf(diskLimitTypeName.trim());
        }
    }

    @Override
    public IDiskCacheAttributes.DiskLimitType getDiskLimitType() {
        return this.diskLimitType;
    }
}

