/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.tools.Utils;

public class MultiMap<A, B> {
    private final Map<A, Set<B>> map;

    public MultiMap() {
        this.map = new HashMap<A, Set<B>>();
    }

    public MultiMap(int capacity) {
        this.map = new HashMap<A, Set<B>>(capacity);
    }

    public MultiMap(Map<A, Set<B>> map0) {
        if (map0 == null) {
            this.map = new HashMap<A, Set<B>>();
        } else {
            this.map = new HashMap<A, Set<B>>(Utils.hashMapInitialCapacity(map0.size()));
            for (Map.Entry<A, Set<B>> e : map0.entrySet()) {
                this.map.put(e.getKey(), new LinkedHashSet(e.getValue()));
            }
        }
    }

    public void put(A key, B value) {
        this.map.computeIfAbsent(key, k -> new LinkedHashSet()).add(value);
    }

    public void putVoid(A key) {
        if (this.map.containsKey(key)) {
            return;
        }
        this.map.put(key, new LinkedHashSet());
    }

    public void putAll(A key, Collection<B> values) {
        this.map.computeIfAbsent(key, k -> new LinkedHashSet(values)).addAll(values);
    }

    public Set<A> keySet() {
        return this.map.keySet();
    }

    public Set<B> get(A key) {
        return this.map.get(key);
    }

    public Set<B> getValues(A key) {
        if (!this.map.containsKey(key)) {
            return new LinkedHashSet();
        }
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(A key) {
        return this.map.containsKey(key);
    }

    public boolean contains(A key, B value) {
        Set<B> values = this.get(key);
        return values != null && values.contains(value);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<Map.Entry<A, Set<B>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public Collection<Set<B>> values() {
        return this.map.values();
    }

    public boolean remove(A key, B value) {
        Set<B> values = this.get(key);
        if (values != null) {
            return values.remove(value);
        }
        return false;
    }

    public Set<B> remove(A key) {
        return this.map.remove(key);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public Map<A, Set<B>> toMap() {
        HashMap<A, Set<B>> result = new HashMap<A, Set<B>>();
        for (Map.Entry<A, Set<B>> e : this.map.entrySet()) {
            result.put(e.getKey(), Collections.unmodifiableSet(e.getValue()));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MultiMap multiMap = (MultiMap)obj;
        return Objects.equals(this.map, multiMap.map);
    }

    public String toString() {
        return this.map.entrySet().stream().map(entry -> entry.getKey() + "->" + entry.getValue()).collect(Collectors.joining(",", "(", ")"));
    }
}

