/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import com.google.common.collect.ImmutableCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.IntrinsicAssignmentTranslator;
import org.jetbrains.kotlin.js.translate.operation.OverloadedAssignmentTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public abstract class AssignmentTranslator
extends AbstractTranslator {
    @NotNull
    protected final KtBinaryExpression expression;
    protected final boolean isVariableReassignment;

    public static boolean isAssignmentOperator(KtToken operationToken) {
        return ((ImmutableCollection)((Object)OperatorConventions.ASSIGNMENT_OPERATIONS.keySet())).contains(operationToken) || PsiUtils.isAssignment(operationToken);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context2) {
        CallableDescriptor operationDescriptor;
        if (expression2 == null) {
            AssignmentTranslator.$$$reportNull$$$1(0);
        }
        if (context2 == null) {
            AssignmentTranslator.$$$reportNull$$$1(1);
        }
        if (expression2 == null) {
            AssignmentTranslator.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            AssignmentTranslator.$$$reportNull$$$0(1);
        }
        if (TranslationUtils.hasCorrespondingFunctionIntrinsic(context2, expression2) && ((operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context2.bindingContext(), expression2)) == null || operationDescriptor.getExtensionReceiverParameter() == null)) {
            JsExpression jsExpression = IntrinsicAssignmentTranslator.doTranslate(expression2, context2);
            if (jsExpression == null) {
                AssignmentTranslator.$$$reportNull$$$0(2);
            }
            if (jsExpression == null) {
                AssignmentTranslator.$$$reportNull$$$1(2);
            }
            return jsExpression;
        }
        JsExpression jsExpression = OverloadedAssignmentTranslator.doTranslate(expression2, context2);
        if (jsExpression == null) {
            AssignmentTranslator.$$$reportNull$$$0(3);
        }
        if (jsExpression == null) {
            AssignmentTranslator.$$$reportNull$$$1(3);
        }
        return jsExpression;
    }

    protected AssignmentTranslator(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            AssignmentTranslator.$$$reportNull$$$1(4);
        }
        if (context2 == null) {
            AssignmentTranslator.$$$reportNull$$$1(5);
        }
        if (expression2 == null) {
            AssignmentTranslator.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            AssignmentTranslator.$$$reportNull$$$0(5);
        }
        super(context2);
        this.expression = expression2;
        this.isVariableReassignment = BindingUtils.isVariableReassignment(context2.bindingContext(), expression2);
        assert (expression2.getLeft() != null) : "No left-hand side: " + expression2.getText();
    }

    protected final AccessTranslator createAccessTranslator(@NotNull KtExpression left, boolean forceOrderOfEvaluation) {
        if (left == null) {
            AssignmentTranslator.$$$reportNull$$$1(6);
        }
        if (left == null) {
            AssignmentTranslator.$$$reportNull$$$0(6);
        }
        if (AssignmentTranslator.isValProperty(left, this.context())) {
            KtSimpleNameExpression simpleName = PsiUtils.getSimpleName(left);
            assert (simpleName != null);
            return BackingFieldAccessTranslator.newInstance(simpleName, this.context());
        }
        return AccessTranslationUtils.getAccessTranslator(left, this.context(), forceOrderOfEvaluation);
    }

    private static boolean isValProperty(@NotNull KtExpression expression2, @NotNull TranslationContext context2) {
        KtSimpleNameExpression simpleNameExpression;
        if (expression2 == null) {
            AssignmentTranslator.$$$reportNull$$$1(7);
        }
        if (context2 == null) {
            AssignmentTranslator.$$$reportNull$$$1(8);
        }
        if (expression2 == null) {
            AssignmentTranslator.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            AssignmentTranslator.$$$reportNull$$$0(8);
        }
        if ((simpleNameExpression = PsiUtils.getSimpleName(expression2)) != null) {
            DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), simpleNameExpression);
            return descriptor2 instanceof PropertyDescriptor && !((PropertyDescriptor)descriptor2).isVar();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAccessTranslator";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValProperty";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAccessTranslator";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValProperty";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

