/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/LocalVariableTypeParametersChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class LocalVariableTypeParametersChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        if (!(declaration2 instanceof KtProperty) || !(descriptor2 instanceof LocalVariableDescriptor)) {
            return;
        }
        List<KtTypeParameter> list2 = ((KtProperty)declaration2).getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "declaration.typeParameters");
        List<KtTypeParameter> typeParameters2 = list2;
        KtTypeParameterList typeParametersList = ((KtProperty)declaration2).getTypeParameterList();
        if (typeParameters2.isEmpty() || typeParametersList == null) {
            return;
        }
        DiagnosticFactory0<KtTypeParameterList> diagnostic = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitTypeParametersForLocalVariables) ? Errors.LOCAL_VARIABLE_WITH_TYPE_PARAMETERS : Errors.LOCAL_VARIABLE_WITH_TYPE_PARAMETERS_WARNING;
        context2.getTrace().report(diagnostic.on((KtTypeParameterList)((PsiElement)typeParametersList)));
    }
}

