/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.Line;
import net.sourceforge.plantuml.graphic.SingleLine;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockRaw
extends AbstractTextBlock
implements TextBlock {
    private List<Line> lines2;
    private final List<String> strings;
    private final FontConfiguration fontConfiguration;

    public TextBlockRaw(List<String> strings, FontConfiguration fontConfiguration) {
        this.strings = strings;
        this.fontConfiguration = fontConfiguration;
    }

    private List<Line> getLines(StringBounder stringBounder) {
        if (this.lines2 == null) {
            if (stringBounder == null) {
                throw new IllegalStateException();
            }
            this.lines2 = new ArrayList<Line>();
            for (String s : this.strings) {
                this.lines2.add(SingleLine.rawText(s, this.fontConfiguration));
            }
        }
        return this.lines2;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getTextDimension(stringBounder);
    }

    protected final Dimension2D getTextDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (Line line : this.getLines(stringBounder)) {
            Dimension2D size2D = line.calculateDimension(stringBounder);
            height += size2D.getHeight();
            width = Math.max(width, size2D.getWidth());
        }
        return new Dimension2DDouble(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        double y = 0.0;
        for (Line line : this.getLines(ug.getStringBounder())) {
            line.drawU(ug.apply(new UTranslate(0.0, y)));
            y += line.calculateDimension(ug.getStringBounder()).getHeight();
        }
    }
}

