/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector2.layering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.hector2.continuity.Skeleton;
import net.sourceforge.plantuml.hector2.layering.Layer;

public class LayerFactory {
    public List<Layer> getLayers(Skeleton skeleton) {
        skeleton = skeleton.removeCycle();
        skeleton.computeLayers();
        ArrayList<Layer> result = new ArrayList<Layer>();
        for (IEntity ent : skeleton.entities()) {
            this.ensureLayer(result, ent.getHectorLayer());
        }
        for (IEntity ent : skeleton.entities()) {
            int layer = ent.getHectorLayer();
            ((Layer)result.get(layer)).add(ent);
        }
        return Collections.unmodifiableList(result);
    }

    private void ensureLayer(List<Layer> result, int layerToAdd) {
        while (result.size() <= layerToAdd) {
            result.add(new Layer(result.size()));
        }
    }
}

