/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.stdlib;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;

public class DateFunction
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%date", 1);
    }

    @Override
    public boolean canCover(int nbArg) {
        return nbArg == 0 || nbArg == 1;
    }

    @Override
    public TValue executeReturn(TContext context, TMemory memory, List<TValue> args) throws EaterException {
        if (args.size() == 0) {
            return TValue.fromString(new Date().toString());
        }
        String format = args.get(0).toString();
        try {
            return TValue.fromString(new SimpleDateFormat(format).format(new Date()));
        }
        catch (Exception e) {
            throw new EaterException("Bad date pattern");
        }
    }
}

