'''OpenGL extension NVX.progress_fence

This module customises the behaviour of the 
OpenGL.raw.GL.NVX.progress_fence to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension uses the concept of GL semaphores as defined in 
	GL_EXT_semaphore to better coordinate operations between multiple
	GPU command streams. A semaphore type called "progress fence" is 
	derived from the GL semaphore. The progress fence semaphore is
	created by CreateProgressFenceNVX() returning the name of a newly
	created semaphore object. Like other semaphores, these are signaled
	by the GL server. Each signal operation is queued in the GPU command
	stream with an associated fence value that is written to the semaphore
	at the completion of a signal operation. 
	
	A GL server wait can be added to the command stream using WaitSemaphoreui64NVX.
	This blocks the GPU until the progress fence semaphore reaches or exceeds the 
	specified fence value.
	
	A GL client wait can be initiated using ClientWaitSemaphoreui64NVX. 
	This blocks the CPU until the specified fence value is reached.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NVX/progress_fence.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NVX.progress_fence import *
from OpenGL.raw.GL.NVX.progress_fence import _EXTENSION_NAME

def glInitProgressFenceNVX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glSignalSemaphoreui64NVX.fenceValueArray size not checked against fenceObjectCount
# INPUT glSignalSemaphoreui64NVX.semaphoreArray size not checked against fenceObjectCount
glSignalSemaphoreui64NVX=wrapper.wrapper(glSignalSemaphoreui64NVX).setInputArraySize(
    'fenceValueArray', None
).setInputArraySize(
    'semaphoreArray', None
)
# INPUT glWaitSemaphoreui64NVX.fenceValueArray size not checked against fenceObjectCount
# INPUT glWaitSemaphoreui64NVX.semaphoreArray size not checked against fenceObjectCount
glWaitSemaphoreui64NVX=wrapper.wrapper(glWaitSemaphoreui64NVX).setInputArraySize(
    'fenceValueArray', None
).setInputArraySize(
    'semaphoreArray', None
)
# INPUT glClientWaitSemaphoreui64NVX.fenceValueArray size not checked against fenceObjectCount
# INPUT glClientWaitSemaphoreui64NVX.semaphoreArray size not checked against fenceObjectCount
glClientWaitSemaphoreui64NVX=wrapper.wrapper(glClientWaitSemaphoreui64NVX).setInputArraySize(
    'fenceValueArray', None
).setInputArraySize(
    'semaphoreArray', None
)
### END AUTOGENERATED SECTION