/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.Util;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.lookup.Lookups;

final class NbStartStop
implements LookupListener {
    private static final RequestProcessor RP = new RequestProcessor("On Start/Stop", 8);
    private final Map<String, RequestProcessor.Task> onStart = new HashMap<String, RequestProcessor.Task>();
    private final Lookup lkpStart;
    private final Lookup lkpStop;
    private Lookup.Result<Runnable> resStart;

    NbStartStop(Lookup lkp, Lookup lkp2) {
        this.lkpStart = lkp;
        this.lkpStop = lkp2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        for (Lookup.Item item : this.onStart().allItems()) {
            Map<String, RequestProcessor.Task> map = this.onStart;
            synchronized (map) {
                Runnable r;
                RequestProcessor.Task already = this.onStart.get(item.getId());
                if (already == null && (r = (Runnable)item.getInstance()) != null) {
                    this.onStart.put(item.getId(), RP.post(r));
                }
            }
        }
    }

    private synchronized Lookup.Result<Runnable> onStart() {
        if (this.resStart == null) {
            Lookup lkp = this.lkpStart != null ? this.lkpStart : Lookups.forPath((String)"Modules/Start");
            this.resStart = lkp.lookupResult(Runnable.class);
            this.resStart.addLookupListener((LookupListener)this);
        }
        return this.resStart;
    }

    private Lookup onStop() {
        return this.lkpStop != null ? this.lkpStop : Lookups.forPath((String)"Modules/Stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitOnStart() {
        RequestProcessor.Task[] taskArray = this.onStart;
        synchronized (this.onStart) {
            Collection<RequestProcessor.Task> values = this.onStart.values();
            RequestProcessor.Task[] all = values.toArray(new RequestProcessor.Task[values.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (RequestProcessor.Task t : all) {
                t.waitFinished();
            }
            return;
        }
    }

    boolean closing(List<? extends ModuleInfo> modules) {
        for (Callable c : this.onStop().lookupAll(Callable.class)) {
            if (!modules.contains(Modules.getDefault().ownerOf(c.getClass()))) continue;
            try {
                if (!Boolean.FALSE.equals(c.call())) continue;
                Util.err.log(Level.FINE, "{0} refused to close", c.getClass());
                return false;
            }
            catch (Exception ex) {
                Util.err.log(Level.FINE, c.getClass() + " thrown an exception", ex);
                return false;
            }
        }
        return true;
    }

    List<Task> startClose(List<? extends ModuleInfo> modules) {
        ArrayList<Task> waitFor = new ArrayList<Task>();
        for (Runnable r : this.onStop().lookupAll(Runnable.class)) {
            if (!modules.contains(Modules.getDefault().ownerOf(r.getClass()))) continue;
            waitFor.add((Task)RP.post(r));
        }
        return waitFor;
    }

    public void resultChanged(LookupEvent ev) {
        this.initialize();
    }
}

