/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.sdedit.util.DOMNode;
import net.sf.sdedit.util.DOMNodeAdapter;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocUtil {
    private static DocumentBuilder documentBuilder;
    private static Transformer transformer;
    private static XPathFactory xPathFactory;

    private DocUtil() {
    }

    public static String evalXPathAsString(Document document, String expression) throws XMLException {
        XPath xpath = xPathFactory.newXPath();
        try {
            return xpath.evaluate(expression, document);
        }
        catch (XPathExpressionException xee) {
            throw new XMLException("Could not evaluate XPath: " + expression, xee);
        }
    }

    public static String evaluateCDATA(Document document, String xPath) throws XMLException {
        StringBuffer buffer = new StringBuffer();
        Element elem = (Element)DocUtil.evalXPathAsNode(document, xPath);
        if (elem != null) {
            NodeList children = elem.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (!(children.item(i) instanceof CDATASection)) continue;
                buffer.append(((CDATASection)children.item(i)).getTextContent());
            }
        }
        return buffer.toString();
    }

    public static Node evalXPathAsNode(Document document, String expression) throws XMLException {
        XPath xpath = xPathFactory.newXPath();
        try {
            Node result = (Node)xpath.evaluate(expression, document, XPathConstants.NODE);
            return result;
        }
        catch (XPathExpressionException xee) {
            throw new XMLException("Could not evaluate XPath: " + expression, xee);
        }
    }

    public static NodeList evalXPathAsNodeList(Document document, String expression) throws XMLException {
        XPath xpath = xPathFactory.newXPath();
        try {
            return (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xee) {
            throw new XMLException("Could not evaluate XPath: " + expression, xee);
        }
    }

    public static Document newDocument() {
        return documentBuilder.newDocument();
    }

    public static Node getChild(Node parent, String name) {
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!name.equals(list.item(i).getNodeName())) continue;
            return list.item(i);
        }
        return null;
    }

    public static String getAttribute(Element element, String name) {
        NamedNodeMap nnm = element.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            if (!name.equalsIgnoreCase(nnm.item(i).getNodeName())) continue;
            return nnm.item(i).getNodeValue();
        }
        return null;
    }

    public static <T extends Node> Iterable<T> select(Node context, String xpath, Class<T> nodeClass) {
        NodeList nodeList;
        XPath path = xPathFactory.newXPath();
        try {
            nodeList = (NodeList)path.evaluate(xpath, context, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xee) {
            throw new IllegalArgumentException("Could not evaluate XPath: " + xpath, xee);
        }
        return DocUtil.iterate(nodeList, nodeClass);
    }

    public static <T extends Node> T selectFirst(Node context, String xpath, Class<T> nodeClass) {
        Iterator<T> iterator = DocUtil.select(context, xpath, nodeClass).iterator();
        if (iterator.hasNext()) {
            Node t = (Node)iterator.next();
            return (T)t;
        }
        return null;
    }

    public static <T extends Node> Iterable<T> iterate(final NodeList nodeList, final Class<T> nodeClass) {
        final Iterator iter = new Iterator<T>(){
            private int i = 0;

            private int findNext() {
                int j;
                for (j = this.i; j < nodeList.getLength() && !nodeClass.isInstance(nodeList.item(j)); ++j) {
                }
                return j;
            }

            @Override
            public boolean hasNext() {
                int j = this.findNext();
                return j < nodeList.getLength();
            }

            @Override
            public T next() {
                this.i = this.findNext();
                return (Node)nodeClass.cast(nodeList.item(this.i++));
            }

            @Override
            public void remove() {
            }
        };
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iter;
            }
        };
    }

    public static Iterable<Node> iterate(NodeList nodeList) {
        return DocUtil.iterate(nodeList, Node.class);
    }

    private static void toString(PrintWriter printWriter, Node node, boolean deep) {
        if (node instanceof Element) {
            printWriter.print("<");
            Element element = (Element)node;
            printWriter.print(element.getNodeName());
            NamedNodeMap nnm = element.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node attr = nnm.item(i);
                printWriter.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
            if (!deep || element.getChildNodes().getLength() == 0) {
                printWriter.print("/>");
            } else {
                printWriter.print(">");
            }
            if (deep) {
                NodeList list = element.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    DocUtil.toString(printWriter, list.item(i), true);
                }
            }
            if (deep && element.getChildNodes().getLength() > 0) {
                printWriter.print("</" + element.getNodeName() + ">");
            }
        }
        if (node instanceof Text) {
            Text text = (Text)node;
            printWriter.print(text.getWholeText() == null ? "" : text.getWholeText().trim());
        }
    }

    public static String toString(Node node) {
        return DocUtil.toString(node, false);
    }

    public static String toString(Node node, boolean deep) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DocUtil.toString(pw, node, deep);
        return sw.toString();
    }

    public static void writeDocument(Document document, String encoding, OutputStream out, Writer writer, boolean omitXMLDeclaration) throws IOException, XMLException {
        if (writer == null) {
            writer = new OutputStreamWriter(out, encoding);
        }
        transformer.setOutputProperty("encoding", encoding);
        transformer.setOutputProperty("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(writer);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new XMLException("writeDocument failed", e);
        }
        writer.flush();
    }

    public static void writeDocument(Document document, String encoding, OutputStream out) throws IOException, XMLException {
        DocUtil.writeDocument(document, encoding, out, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document readDocument(InputStream in, String encoding) throws IOException, XMLException {
        try {
            Document document;
            InputStreamReader reader = new InputStreamReader(in, encoding);
            InputSource source = new InputSource(new BufferedReader(reader));
            try {
                document = documentBuilder.parse(source);
            }
            catch (SAXException e) {
                throw new XMLException("readDocument failed", e);
            }
            Document document2 = document;
            return document2;
        }
        finally {
            in.close();
        }
    }

    public static DOMNode toDOMNode(Document document) {
        Element elem = document.getDocumentElement();
        return DOMNodeAdapter.makeNode(elem);
    }

    public static DOMNode getDocumentFromURL(URL url, String encoding) {
        try {
            Document doc = DocUtil.readDocument(url.openStream(), encoding);
            return DocUtil.toDOMNode(doc);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    static {
        xPathFactory = XPathFactory.newInstance();
        DocumentBuilderFactory factory = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            try {
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            }
            catch (Throwable pce) {
                System.err.println("Warning: " + pce.getMessage());
            }
            try {
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (Throwable pce) {
                System.err.println("Warning: " + pce.getMessage());
            }
            documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setEntityResolver(null);
            transformer = TransformerFactory.newInstance().newTransformer();
            factory.setIgnoringElementContentWhitespace(true);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class XMLException
    extends Exception {
        private static final long serialVersionUID = -6835267522941428813L;

        private XMLException(String msg) {
            super(msg);
        }

        private XMLException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

