/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.gjt.sp.jedit.bsh.BshClassManager;
import org.gjt.sp.jedit.bsh.ClassPathException;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.InterpreterError;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.bsh.classpath.BshClassLoader;
import org.gjt.sp.jedit.bsh.classpath.BshClassPath;
import org.gjt.sp.jedit.bsh.classpath.DiscreteFilesClassLoader;

public class ClassManagerImpl
extends BshClassManager {
    static final String BSH_PACKAGE = "org.gjt.sp.jedit.bsh";
    private BshClassPath baseClassPath;
    private boolean superImport;
    private BshClassPath fullClassPath;
    private Vector listeners = new Vector();
    private ReferenceQueue refQueue = new ReferenceQueue();
    private BshClassLoader baseLoader;
    private Map loaderMap;

    public ClassManagerImpl() {
        this.reset();
    }

    @Override
    public Class classForName(String string) {
        ClassLoader classLoader;
        Class<?> clazz = (Class<?>)this.absoluteClassCache.get(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.absoluteNonClasses.get(string) != null) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("absoluteNonClass list hit: " + string);
            }
            return null;
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("Trying to load class: " + string);
        }
        if ((classLoader = this.getLoaderForClass(string)) != null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (Exception exception) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw ClassManagerImpl.noClassDefFound(string, noClassDefFoundError);
            }
        }
        if (clazz == null && string.startsWith(BSH_PACKAGE)) {
            try {
                clazz = Interpreter.class.getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null && this.baseLoader != null) {
            try {
                clazz = this.baseLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null && this.externalClassLoader != null) {
            try {
                clazz = this.externalClassLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                if (classLoader2 != null) {
                    clazz = Class.forName(string, true, classLoader2);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                clazz = this.plainClassForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = this.loadSourceClass(string);
        }
        this.cacheClassInfo(string, clazz);
        return clazz;
    }

    @Override
    public URL getResource(String string) {
        URL uRL = null;
        if (this.baseLoader != null) {
            uRL = this.baseLoader.getResource(string.substring(1));
        }
        if (uRL == null) {
            uRL = super.getResource(string);
        }
        return uRL;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.baseLoader != null) {
            inputStream = this.baseLoader.getResourceAsStream(string.substring(1));
        }
        if (inputStream == null) {
            inputStream = super.getResourceAsStream(string);
        }
        return inputStream;
    }

    ClassLoader getLoaderForClass(String string) {
        return (ClassLoader)this.loaderMap.get(string);
    }

    @Override
    public void addClassPath(URL uRL) throws IOException {
        if (this.baseLoader == null) {
            this.setClassPath(new URL[]{uRL});
        } else {
            this.baseLoader.addURL(uRL);
            this.baseClassPath.add(uRL);
            this.classLoaderChanged();
        }
    }

    @Override
    public void reset() {
        this.baseClassPath = new BshClassPath("baseClassPath");
        this.baseLoader = null;
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    @Override
    public void setClassPath(URL[] uRLArray) {
        this.baseClassPath.setPath(uRLArray);
        this.initBaseLoader();
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    @Override
    public void reloadAllClasses() throws ClassPathException {
        BshClassPath bshClassPath = new BshClassPath("temp");
        bshClassPath.addComponent(this.baseClassPath);
        bshClassPath.addComponent(BshClassPath.getUserClassPath());
        this.setClassPath(bshClassPath.getPathComponents());
    }

    private void initBaseLoader() {
        this.baseLoader = new BshClassLoader((BshClassManager)this, this.baseClassPath);
    }

    @Override
    public void reloadClasses(String[] stringArray) throws ClassPathException {
        Object object;
        if (this.baseLoader == null) {
            this.initBaseLoader();
        }
        DiscreteFilesClassLoader.ClassSourceMap classSourceMap = new DiscreteFilesClassLoader.ClassSourceMap();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            BshClassPath.ClassSource classSource = this.baseClassPath.getClassSource((String)object);
            if (classSource == null) {
                BshClassPath.getUserClassPath().insureInitialized();
                classSource = BshClassPath.getUserClassPath().getClassSource((String)object);
            }
            if (classSource == null) {
                throw new ClassPathException("Nothing known about class: " + (String)object);
            }
            if (classSource instanceof BshClassPath.JarClassSource) {
                throw new ClassPathException("Cannot reload class: " + (String)object + " from source: " + classSource);
            }
            classSourceMap.put((String)object, classSource);
        }
        DiscreteFilesClassLoader discreteFilesClassLoader = new DiscreteFilesClassLoader((BshClassManager)this, classSourceMap);
        object = classSourceMap.keySet().iterator();
        while (object.hasNext()) {
            this.loaderMap.put((String)object.next(), discreteFilesClassLoader);
        }
        this.classLoaderChanged();
    }

    @Override
    public void reloadPackage(String string) throws ClassPathException {
        Set set = this.baseClassPath.getClassesForPackage(string);
        if (set == null) {
            set = BshClassPath.getUserClassPath().getClassesForPackage(string);
        }
        if (set == null) {
            throw new ClassPathException("No classes found for package: " + string);
        }
        this.reloadClasses(set.toArray(new String[0]));
    }

    public BshClassPath getClassPath() throws ClassPathException {
        if (this.fullClassPath != null) {
            return this.fullClassPath;
        }
        this.fullClassPath = new BshClassPath("BeanShell Full Class Path");
        this.fullClassPath.addComponent(BshClassPath.getUserClassPath());
        try {
            this.fullClassPath.addComponent(BshClassPath.getBootClassPath());
        }
        catch (ClassPathException classPathException) {
            System.err.println("Warning: can't get boot class path");
        }
        this.fullClassPath.addComponent(this.baseClassPath);
        return this.fullClassPath;
    }

    @Override
    public void doSuperImport() throws UtilEvalError {
        try {
            this.getClassPath().insureInitialized();
            this.getClassNameByUnqName("");
        }
        catch (ClassPathException classPathException) {
            throw new UtilEvalError("Error importing classpath " + classPathException);
        }
        this.superImport = true;
    }

    @Override
    protected boolean hasSuperImport() {
        return this.superImport;
    }

    @Override
    public String getClassNameByUnqName(String string) throws ClassPathException {
        return this.getClassPath().getClassNameByUnqName(string);
    }

    @Override
    public void addListener(BshClassManager.Listener listener) {
        Reference reference;
        this.listeners.addElement(new WeakReference<BshClassManager.Listener>(listener, this.refQueue));
        while ((reference = this.refQueue.poll()) != null) {
            boolean bl = this.listeners.removeElement(reference);
            if (bl || !Interpreter.DEBUG) continue;
            Interpreter.debug("tried to remove non-existent weak ref: " + reference);
        }
    }

    @Override
    public void removeListener(BshClassManager.Listener listener) {
        throw new Error("unimplemented");
    }

    public ClassLoader getBaseLoader() {
        return this.baseLoader;
    }

    @Override
    public Class defineClass(String string, byte[] byArray) {
        this.baseClassPath.setClassSource(string, new BshClassPath.GeneratedClassSource(byArray));
        try {
            this.reloadClasses(new String[]{string});
        }
        catch (ClassPathException classPathException) {
            throw new InterpreterError("defineClass: " + classPathException);
        }
        return this.classForName(string);
    }

    @Override
    protected void classLoaderChanged() {
        this.clearCaches();
        Vector<WeakReference> vector = new Vector<WeakReference>();
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            WeakReference weakReference = (WeakReference)enumeration.nextElement();
            BshClassManager.Listener listener = (BshClassManager.Listener)weakReference.get();
            if (listener == null) {
                vector.add(weakReference);
                continue;
            }
            listener.classLoaderChanged();
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.listeners.removeElement(enumeration.nextElement());
        }
    }

    @Override
    public void dump(PrintWriter printWriter) {
        printWriter.println("Bsh Class Manager Dump: ");
        printWriter.println("----------------------- ");
        printWriter.println("baseLoader = " + this.baseLoader);
        printWriter.println("loaderMap= " + this.loaderMap);
        printWriter.println("----------------------- ");
        printWriter.println("baseClassPath = " + this.baseClassPath);
    }
}

