/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.tomcat.util.buf.UriUtil;

public class WebappServiceLoader<T> {
    private static final String CLASSES = "/WEB-INF/classes/";
    private static final String LIB = "/WEB-INF/lib/";
    private static final String SERVICES = "META-INF/services/";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Context context;
    private final ServletContext servletContext;
    private final Pattern containerSciFilterPattern;

    public WebappServiceLoader(Context context) {
        this.context = context;
        this.servletContext = context.getServletContext();
        String containerSciFilter = context.getContainerSciFilter();
        this.containerSciFilterPattern = containerSciFilter != null && containerSciFilter.length() > 0 ? Pattern.compile(containerSciFilter) : null;
    }

    public List<T> load(Class<T> serviceType) throws IOException {
        Enumeration<URL> resources;
        String configFile = SERVICES + serviceType.getName();
        LinkedHashSet<String> applicationServicesFound = new LinkedHashSet<String>();
        LinkedHashSet<String> containerServicesFound = new LinkedHashSet<String>();
        ClassLoader loader = this.servletContext.getClassLoader();
        List orderedLibs = (List)this.servletContext.getAttribute("javax.servlet.context.orderedLibs");
        if (orderedLibs == null) {
            if (loader instanceof URLClassLoader) {
                resources = ((URLClassLoader)loader).findResources("/" + configFile);
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    this.parseConfigFile(applicationServicesFound, resource);
                }
            }
        } else {
            URL unpacked = this.servletContext.getResource(CLASSES + configFile);
            if (unpacked != null) {
                this.parseConfigFile(applicationServicesFound, unpacked);
            }
            for (String lib : orderedLibs) {
                URL jarUrl = this.servletContext.getResource(LIB + lib);
                if (jarUrl == null) continue;
                String base = jarUrl.toExternalForm();
                URL url = base.endsWith("/") ? new URL(base + configFile) : UriUtil.buildJarUrl((String)base, (String)configFile);
                try {
                    this.parseConfigFile(applicationServicesFound, url);
                }
                catch (FileNotFoundException e) {}
            }
        }
        resources = (loader = this.context.getParentClassLoader()) == null ? ClassLoader.getSystemResources(configFile) : loader.getResources(configFile);
        while (resources.hasMoreElements()) {
            this.parseConfigFile(containerServicesFound, resources.nextElement());
        }
        if (this.containerSciFilterPattern != null) {
            Iterator iter = containerServicesFound.iterator();
            while (iter.hasNext()) {
                if (!this.containerSciFilterPattern.matcher((CharSequence)iter.next()).find()) continue;
                iter.remove();
            }
        }
        containerServicesFound.addAll(applicationServicesFound);
        if (containerServicesFound.isEmpty()) {
            return Collections.emptyList();
        }
        return this.loadServices(serviceType, containerServicesFound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseConfigFile(LinkedHashSet<String> servicesFound, URL url) throws IOException {
        InputStream is = null;
        BufferedReader reader = null;
        try {
            String line;
            is = url.openStream();
            InputStreamReader in = new InputStreamReader(is, UTF8);
            reader = new BufferedReader(in);
            while ((line = reader.readLine()) != null) {
                int i = line.indexOf(35);
                if (i >= 0) {
                    line = line.substring(0, i);
                }
                if ((line = line.trim()).length() == 0) continue;
                servicesFound.add(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    private List<T> loadServices(Class<T> serviceType, LinkedHashSet<String> servicesFound) throws IOException {
        ClassLoader loader = this.servletContext.getClassLoader();
        ArrayList<T> services = new ArrayList<T>(servicesFound.size());
        for (String serviceClass : servicesFound) {
            try {
                Class<?> clazz = Class.forName(serviceClass, true, loader);
                services.add(serviceType.cast(clazz.newInstance()));
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (ClassCastException e) {
                throw new IOException(e);
            }
        }
        return Collections.unmodifiableList(services);
    }
}

