/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre7Compat;
import org.apache.tomcat.util.res.StringManager;

class Jre8Compat
extends Jre7Compat {
    private static final Log log = LogFactory.getLog(Jre8Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre8Compat.class);
    private static final int RUNTIME_MAJOR_VERSION = 8;
    private static final Method getSSLParametersMethod;
    private static final Method setUseCipherSuitesOrderMethod;
    private static final Method setSSLParametersMethod;

    Jre8Compat() {
    }

    static boolean isSupported() {
        return setUseCipherSuitesOrderMethod != null;
    }

    @Override
    public void setUseServerCipherSuitesOrder(SSLServerSocket socket, boolean useCipherSuitesOrder) {
        try {
            Object sslParameters = getSSLParametersMethod.invoke((Object)socket, new Object[0]);
            setUseCipherSuitesOrderMethod.invoke(sslParameters, useCipherSuitesOrder);
            setSSLParametersMethod.invoke((Object)socket, sslParameters);
            return;
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void setUseServerCipherSuitesOrder(SSLEngine engine, boolean useCipherSuitesOrder) {
        SSLParameters sslParameters = engine.getSSLParameters();
        try {
            setUseCipherSuitesOrderMethod.invoke((Object)sslParameters, useCipherSuitesOrder);
            engine.setSSLParameters(sslParameters);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int jarFileRuntimeMajorVersion() {
        return 8;
    }

    static {
        Method m1 = null;
        Method m2 = null;
        Method m3 = null;
        try {
            Class<?> c2 = Class.forName("javax.net.ssl.SSLParameters");
            m1 = c2.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
            m2 = SSLServerSocket.class.getMethod("getSSLParameters", new Class[0]);
            m3 = SSLServerSocket.class.getMethod("setSSLParameters", c2);
        }
        catch (SecurityException e) {
            log.error((Object)sm.getString("jre8Compat.unexpected"), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            if (m1 == null) {
                log.debug((Object)sm.getString("jre8Compat.javaPre8"), (Throwable)e);
            } else {
                log.error((Object)sm.getString("jre8Compat.unexpected"), (Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)sm.getString("jre8Compat.javaPre7"), (Throwable)e);
        }
        setUseCipherSuitesOrderMethod = m1;
        getSSLParametersMethod = m2;
        setSSLParametersMethod = m3;
    }
}

