#ifndef _EFL_CANVAS_ANIMATION_EO_H_
#define _EFL_CANVAS_ANIMATION_EO_H_

#ifndef _EFL_CANVAS_ANIMATION_EO_CLASS_TYPE
#define _EFL_CANVAS_ANIMATION_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Animation;

#endif

#ifndef _EFL_CANVAS_ANIMATION_EO_TYPES
#define _EFL_CANVAS_ANIMATION_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl animation class
 *
 * @ingroup Efl_Canvas_Animation
 */
#define EFL_CANVAS_ANIMATION_CLASS efl_canvas_animation_class_get()

EWAPI const Efl_Class *efl_canvas_animation_class_get(void);

/**
 * @brief Keep final state property
 *
 * @param[in] obj The object.
 * @param[in] keep @c true to keep final state, @c false otherwise.
 *
 * @ingroup Efl_Canvas_Animation
 */
EOAPI void efl_animation_final_state_keep_set(Eo *obj, Eina_Bool keep);

/**
 * @brief Keep final state property
 *
 * @param[in] obj The object.
 *
 * @return @c true to keep final state, @c false otherwise.
 *
 * @ingroup Efl_Canvas_Animation
 */
EOAPI Eina_Bool efl_animation_final_state_keep_get(const Eo *obj);

/**
 * @brief Duration property
 *
 * @param[in] obj The object.
 * @param[in] sec Duration value.
 *
 * @ingroup Efl_Canvas_Animation
 */
EOAPI void efl_animation_duration_set(Eo *obj, double sec);

/**
 * @brief Duration property
 *
 * @param[in] obj The object.
 *
 * @return Duration value.
 *
 * @ingroup Efl_Canvas_Animation
 */
EOAPI double efl_animation_duration_get(const Eo *obj);

/**
 * @brief Repeat mode property
 *
 * @param[in] obj The object.
 * @param[in] mode Repeat mode.
 *
 * @ingroup Efl_Canvas_Animation
 */
EOAPI void efl_animation_repeat_mode_set(Eo *obj, Efl_Canvas_Animation_Repeat_Mode mode);

/**
 * @brief Repeat mode property
 *
 * @param[in] obj The object.
 *
 * @return Repeat mode.
 *
 * @ingroup Efl_Canvas_Animation
 */
EOAPI Efl_Canvas_Animation_Repeat_Mode efl_animation_repeat_mode_get(const Eo *obj);

/**
 * @brief Repeat count property
 *
 * @param[in] obj The object.
 * @param[in] count Repeat count. -1 repeats animation infinitely.
 *
 * @ingroup Efl_Canvas_Animation
 */
EOAPI void efl_animation_repeat_count_set(Eo *obj, int count);

/**
 * @brief Repeat count property
 *
 * @param[in] obj The object.
 *
 * @return Repeat count. -1 repeats animation infinitely.
 *
 * @ingroup Efl_Canvas_Animation
 */
EOAPI int efl_animation_repeat_count_get(const Eo *obj);

/**
 * @brief Start delay property
 *
 * @param[in] obj The object.
 * @param[in] sec Delay time, in seconds, from when the animation starts until
 * the animation is animated.
 *
 * @ingroup Efl_Canvas_Animation
 */
EOAPI void efl_animation_start_delay_set(Eo *obj, double sec);

/**
 * @brief Start delay property
 *
 * @param[in] obj The object.
 *
 * @return Delay time, in seconds, from when the animation starts until the
 * animation is animated.
 *
 * @ingroup Efl_Canvas_Animation
 */
EOAPI double efl_animation_start_delay_get(const Eo *obj);

/**
 * @brief Interpolator property
 *
 * @param[in] obj The object.
 * @param[in] interpolator Interpolator which indicates interpolation function.
 *
 * @ingroup Efl_Canvas_Animation
 */
EOAPI void efl_animation_interpolator_set(Eo *obj, Efl_Interpolator *interpolator);

/**
 * @brief Interpolator property
 *
 * @param[in] obj The object.
 *
 * @return Interpolator which indicates interpolation function.
 *
 * @ingroup Efl_Canvas_Animation
 */
EOAPI Efl_Interpolator *efl_animation_interpolator_get(const Eo *obj);

EOAPI double efl_animation_apply(Eo *obj, double progress, Efl_Canvas_Object *target);
#endif /* EFL_BETA_API_SUPPORT */

#endif
