/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.search.SearchTerm;

public abstract class StringTerm
extends SearchTerm {
    protected String pattern;
    protected boolean ignoreCase;

    protected StringTerm(String pattern) {
        this(pattern, true);
    }

    protected StringTerm(String pattern, boolean ignoreCase) {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    protected boolean match(String s) {
        int patlen = this.pattern.length();
        int len = s.length() - patlen;
        for (int i = 0; i <= len; ++i) {
            if (!s.regionMatches(this.ignoreCase, i, this.pattern, 0, patlen)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof StringTerm) {
            StringTerm st = (StringTerm)other;
            if (this.ignoreCase) {
                return st.pattern.equalsIgnoreCase(this.pattern) && st.ignoreCase == this.ignoreCase;
            }
            return st.pattern.equals(this.pattern) && st.ignoreCase == this.ignoreCase;
        }
        return false;
    }

    public int hashCode() {
        return this.ignoreCase ? this.pattern.hashCode() : ~this.pattern.hashCode();
    }
}

