// Generated by gmmproc 2.62.0 -- DO NOT MODIFY!
#ifndef _GTKMM_COLORSELECTION_H
#define _GTKMM_COLORSELECTION_H


#ifndef GTKMM_DISABLE_DEPRECATED


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <vector>

#include <gtkmm/box.h>
#include <gtkmm/dialog.h>
#include <gtkmm/button.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkColorSelection = struct _GtkColorSelection;
using GtkColorSelectionClass = struct _GtkColorSelectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class ColorSelection_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkColorSelectionDialog = struct _GtkColorSelectionDialog;
using GtkColorSelectionDialogClass = struct _GtkColorSelectionDialogClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class ColorSelectionDialog_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** A widget used to select a color.
 *
 * This widget is used to select a color. It
 * consists of a color wheel and number of sliders and entry boxes for color
 * parameters such as hue, saturation, value, red, green, blue, and opacity.
 *
 * It is found on the standard color selection dialog box
 * Gtk::ColorSelectionDialog.
 *
 * @ingroup Widgets
 * @deprecated Use ColorButton or ColorChooserDialog instead.
 */

class ColorSelection : public VBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ColorSelection CppObjectType;
  typedef ColorSelection_Class CppClassType;
  typedef GtkColorSelection BaseObjectType;
  typedef GtkColorSelectionClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  ColorSelection(ColorSelection&& src) noexcept;
  ColorSelection& operator=(ColorSelection&& src) noexcept;

  // noncopyable
  ColorSelection(const ColorSelection&) = delete;
  ColorSelection& operator=(const ColorSelection&) = delete;

  ~ColorSelection() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ColorSelection_Class;
  static CppClassType colorselection_class_;

protected:
  explicit ColorSelection(const Glib::ConstructParams& construct_params);
  explicit ColorSelection(GtkColorSelection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkColorSelection*       gobj()       { return reinterpret_cast<GtkColorSelection*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkColorSelection* gobj() const { return reinterpret_cast<GtkColorSelection*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_color_changed().
  virtual void on_color_changed();


private:

  
public:
  ColorSelection();

  
  /** Determines whether the colorsel has an opacity control.
   * 
   * @return <tt>true</tt> if the @a colorsel has an opacity control,
   * <tt>false</tt> if it does't.
   */
  bool get_has_opacity_control() const;
  
  /** Sets the @a colorsel to use or not use opacity.
   * 
   * @param has_opacity <tt>true</tt> if @a colorsel can set the opacity, <tt>false</tt> otherwise.
   */
  void set_has_opacity_control(bool has_opacity =  true);
  
  /** Determines whether the color selector has a color palette.
   * 
   * @return <tt>true</tt> if the selector has a palette, <tt>false</tt> if it hasn't.
   */
  bool get_has_palette() const;
  
  /** Shows and hides the palette based upon the value of @a has_palette.
   * 
   * @param has_palette <tt>true</tt> if palette is to be visible, <tt>false</tt> otherwise.
   */
  void set_has_palette(bool has_palette =  true);
  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Sets the current color to be @a color.
   * 
   * The first time this is called, it will also set
   * the original color to be @a color too.
   * 
   * Deprecated: 3.4: Use set_current_rgba() instead.
   * 
   * @deprecated Use set_current_rgba() instead.
   * 
   * @param color A Gdk::Color to set the current color with.
   */
  void set_current_color(const Gdk::Color& color);
#endif // GTKMM_DISABLE_DEPRECATED


  /** Sets the current opacity to be @a alpha.
   * 
   * The first time this is called, it will also set
   * the original opacity to be @a alpha too.
   * 
   * @param alpha An integer between 0 and 65535.
   */
  void set_current_alpha(guint16 alpha);
  Gdk::Color get_current_color() const;
  
  /** Returns the current alpha value.
   * 
   * @return An integer between 0 and 65535.
   */
  guint16 get_current_alpha() const;
  
  /** Sets the “previous” color to be @a color.
   * 
   * This function should be called with some hesitations,
   * as it might seem confusing to have that color change.
   * Calling set_current_color() will also
   * set this color the first time it is called.
   * 
   * Deprecated: 3.4: Use set_previous_rgba() instead.
   * 
   * @param color A Gdk::Color to set the previous color with.
   */
  void set_previous_color(const Gdk::Color& color);
  
  /** Sets the “previous” alpha to be @a alpha.
   * 
   * This function should be called with some hesitations,
   * as it might seem confusing to have that alpha change.
   * 
   * @param alpha An integer between 0 and 65535.
   */
  void set_previous_alpha(guint16 alpha);
  Gdk::Color get_previous_color() const;
  
  /** Returns the previous alpha value.
   * 
   * @return An integer between 0 and 65535.
   */
  guint16 get_previous_alpha() const;

  
  Gdk::RGBA get_current_rgba() const;
  Gdk::RGBA get_previous_rgba() const;

  
  /** Sets the current color to be @a rgba.
   * 
   * The first time this is called, it will also set
   * the original color to be @a rgba too.
   * 
   * @newin{3,0}
   * 
   * @param rgba A Gdk::RGBA to set the current color with.
   */
  void set_current_rgba(const Gdk::RGBA& rgba);
  
  /** Sets the “previous” color to be @a rgba.
   * 
   * This function should be called with some hesitations,
   * as it might seem confusing to have that color change.
   * Calling set_current_rgba() will also
   * set this color the first time it is called.
   * 
   * @newin{3,0}
   * 
   * @param rgba A Gdk::RGBA to set the previous color with.
   */
  void set_previous_rgba(const Gdk::RGBA& rgba);

  
  /** Gets the current state of the @a colorsel.
   * 
   * @return <tt>true</tt> if the user is currently dragging
   * a color around, and <tt>false</tt> if the selection has stopped.
   */
  bool is_adjusting() const;

  static std::vector<Gdk::Color> palette_from_string(const Glib::ustring& str);
  static Glib::ustring palette_to_string(const std::vector<Gdk::Color>& colors);

  typedef sigc::slot<void, const Glib::RefPtr<Gdk::Screen>&,
                            const std::vector<Gdk::Color>&> SlotChangePaletteHook;

  static SlotChangePaletteHook set_change_palette_hook(const SlotChangePaletteHook& slot);

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%color_changed()</tt>
   *
   * Flags: Run First
   *
   * This signal is emitted when the color changes in the Gtk::ColorSelection
   * according to its update policy.
   */

  Glib::SignalProxy< void > signal_color_changed();


  /** Whether a palette should be used.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_has_palette() ;

/** Whether a palette should be used.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_palette() const;

  /** Whether the color selector should allow setting opacity.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_has_opacity_control() ;

/** Whether the color selector should allow setting opacity.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_opacity_control() const;

  /** The current GdkColor color.
   * 
   * Deprecated: 3.4: Use Gtk::ColorSelection::property_current_rgba() instead.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::Color > property_current_color() ;

/** The current GdkColor color.
   * 
   * Deprecated: 3.4: Use Gtk::ColorSelection::property_current_rgba() instead.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::Color > property_current_color() const;

  /** The current opacity value (0 fully transparent, 65535 fully opaque).
   *
   * Default value: 65535
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_current_alpha() ;

/** The current opacity value (0 fully transparent, 65535 fully opaque).
   *
   * Default value: 65535
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_current_alpha() const;

  //The whole class was deprecated before this was added: _WRAP_PROPERTY("current-rgba", Gdk::RGBA)


};

/** This dialog allows the user to select a color.
 *
 * A ColorSelectionDialog looks like this:
 * @image html colorselectiondialog1.png
 *
 * @ingroup Dialogs
 * @deprecated Use ColorChooserDialog instead.
 */

class ColorSelectionDialog : public Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ColorSelectionDialog CppObjectType;
  typedef ColorSelectionDialog_Class CppClassType;
  typedef GtkColorSelectionDialog BaseObjectType;
  typedef GtkColorSelectionDialogClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  ColorSelectionDialog(ColorSelectionDialog&& src) noexcept;
  ColorSelectionDialog& operator=(ColorSelectionDialog&& src) noexcept;

  // noncopyable
  ColorSelectionDialog(const ColorSelectionDialog&) = delete;
  ColorSelectionDialog& operator=(const ColorSelectionDialog&) = delete;

  ~ColorSelectionDialog() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ColorSelectionDialog_Class;
  static CppClassType colorselectiondialog_class_;

protected:
  explicit ColorSelectionDialog(const Glib::ConstructParams& construct_params);
  explicit ColorSelectionDialog(GtkColorSelectionDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkColorSelectionDialog*       gobj()       { return reinterpret_cast<GtkColorSelectionDialog*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkColorSelectionDialog* gobj() const { return reinterpret_cast<GtkColorSelectionDialog*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
public:

  ColorSelectionDialog();
    explicit ColorSelectionDialog(const Glib::ustring& title);


  /** Retrieves the Gtk::ColorSelection widget embedded in the dialog.
   * 
   * @newin{2,14}
   * 
   * @return The embedded Gtk::ColorSelection.
   */
  ColorSelection* get_color_selection();
  
  /** Retrieves the Gtk::ColorSelection widget embedded in the dialog.
   * 
   * @newin{2,14}
   * 
   * @return The embedded Gtk::ColorSelection.
   */
  const ColorSelection* get_color_selection() const;

  /** The color selection embedded in the dialog.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ColorSelection* > property_color_selection() const;


  /** The OK button of the dialog.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Button* > property_ok_button() const;


  /** The cancel button of the dialog.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Button* > property_cancel_button() const;


  /** The help button of the dialog.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Button* > property_help_button() const;


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ColorSelection
   */
  Gtk::ColorSelection* wrap(GtkColorSelection* object, bool take_copy = false);
} //namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ColorSelectionDialog
   */
  Gtk::ColorSelectionDialog* wrap(GtkColorSelectionDialog* object, bool take_copy = false);
} //namespace Glib


#endif // GTKMM_DISABLE_DEPRECATED


#endif /* _GTKMM_COLORSELECTION_H */

