/*
 * Decompiled with CFR 0.152.
 */
package javax.accessibility;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class AccessibleBundle {
    private static Hashtable table = new Hashtable();
    private final String defaultResourceBundleName = "com.sun.accessibility.internal.resources.accessibility";
    protected String key = null;

    protected String toDisplayString(String resourceBundleName, Locale locale) {
        Hashtable resourceTable;
        this.loadResourceBundle(resourceBundleName, locale);
        Object o = table.get(locale);
        if (o != null && o instanceof Hashtable && (o = (resourceTable = (Hashtable)o).get(this.key)) != null && o instanceof String) {
            return (String)o;
        }
        return this.key;
    }

    public String toDisplayString(Locale locale) {
        return this.toDisplayString("com.sun.accessibility.internal.resources.accessibility", locale);
    }

    public String toDisplayString() {
        return this.toDisplayString(Locale.getDefault());
    }

    public String toString() {
        return this.toDisplayString();
    }

    private void loadResourceBundle(String resourceBundleName, Locale locale) {
        if (!table.contains(locale)) {
            try {
                Hashtable<String, Object> resourceTable = new Hashtable<String, Object>();
                ResourceBundle bundle = ResourceBundle.getBundle(resourceBundleName, locale);
                Enumeration<String> iter = bundle.getKeys();
                while (iter.hasMoreElements()) {
                    String key = iter.nextElement();
                    resourceTable.put(key, bundle.getObject(key));
                }
                table.put(locale, resourceTable);
            }
            catch (MissingResourceException e) {
                System.err.println("loadResourceBundle: " + e);
                return;
            }
        }
    }
}

