/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import sun.misc.HexDumpEncoder;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class IPAddressName
implements GeneralNameInterface {
    private byte[] address;
    private boolean isIPv4;
    private String name;
    private static final int MASKSIZE = 16;

    public IPAddressName(DerValue derValue) throws IOException {
        this(derValue.getOctetString());
    }

    public IPAddressName(byte[] address) throws IOException {
        if (address.length == 4 || address.length == 8) {
            this.isIPv4 = true;
        } else if (address.length == 16 || address.length == 32) {
            this.isIPv4 = false;
        } else {
            throw new IOException("Invalid IPAddressName");
        }
        this.address = address;
    }

    public IPAddressName(String name) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IOException("IPAddress cannot be null or empty");
        }
        if (name.charAt(name.length() - 1) == '/') {
            throw new IOException("Invalid IPAddress: " + name);
        }
        if (name.indexOf(58) >= 0) {
            this.parseIPv6(name);
            this.isIPv4 = false;
        } else if (name.indexOf(46) >= 0) {
            this.parseIPv4(name);
            this.isIPv4 = true;
        } else {
            throw new IOException("Invalid IPAddress: " + name);
        }
    }

    private void parseIPv4(String name) throws IOException {
        int slashNdx = name.indexOf(47);
        if (slashNdx == -1) {
            this.address = InetAddress.getByName(name).getAddress();
        } else {
            this.address = new byte[8];
            byte[] mask = InetAddress.getByName(name.substring(slashNdx + 1)).getAddress();
            byte[] host = InetAddress.getByName(name.substring(0, slashNdx)).getAddress();
            System.arraycopy(host, 0, this.address, 0, 4);
            System.arraycopy(mask, 0, this.address, 4, 4);
        }
    }

    private void parseIPv6(String name) throws IOException {
        int slashNdx = name.indexOf(47);
        if (slashNdx == -1) {
            this.address = InetAddress.getByName(name).getAddress();
        } else {
            this.address = new byte[32];
            byte[] base = InetAddress.getByName(name.substring(0, slashNdx)).getAddress();
            System.arraycopy(base, 0, this.address, 0, 16);
            int prefixLen = Integer.parseInt(name.substring(slashNdx + 1));
            if (prefixLen < 0 || prefixLen > 128) {
                throw new IOException("IPv6Address prefix length (" + prefixLen + ") in out of valid range [0,128]");
            }
            BitArray bitArray = new BitArray(128);
            for (int i = 0; i < prefixLen; ++i) {
                bitArray.set(i, true);
            }
            byte[] maskArray = bitArray.toByteArray();
            for (int i = 0; i < 16; ++i) {
                this.address[16 + i] = maskArray[i];
            }
        }
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        out.putOctetString(this.address);
    }

    public String toString() {
        try {
            return "IPAddress: " + this.getName();
        }
        catch (IOException ioe) {
            HexDumpEncoder enc = new HexDumpEncoder();
            return "IPAddress: " + enc.encodeBuffer(this.address);
        }
    }

    public String getName() throws IOException {
        if (this.name != null) {
            return this.name;
        }
        if (this.isIPv4) {
            byte[] host = new byte[4];
            System.arraycopy(this.address, 0, host, 0, 4);
            this.name = InetAddress.getByAddress(host).getHostAddress();
            if (this.address.length == 8) {
                byte[] mask = new byte[4];
                System.arraycopy(this.address, 4, mask, 0, 4);
                this.name = this.name + "/" + InetAddress.getByAddress(mask).getHostAddress();
            }
        } else {
            byte[] host = new byte[16];
            System.arraycopy(this.address, 0, host, 0, 16);
            this.name = InetAddress.getByAddress(host).getHostAddress();
            if (this.address.length == 32) {
                int i;
                byte[] maskBytes = new byte[16];
                for (int i2 = 16; i2 < 32; ++i2) {
                    maskBytes[i2 - 16] = this.address[i2];
                }
                BitArray ba = new BitArray(128, maskBytes);
                for (i = 0; i < 128 && ba.get(i); ++i) {
                }
                this.name = this.name + "/" + i;
                while (i < 128) {
                    if (ba.get(i)) {
                        throw new IOException("Invalid IPv6 subdomain - set bit " + i + " not contiguous");
                    }
                    ++i;
                }
            }
        }
        return this.name;
    }

    public byte[] getBytes() {
        return (byte[])this.address.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IPAddressName)) {
            return false;
        }
        IPAddressName otherName = (IPAddressName)obj;
        byte[] other = otherName.address;
        if (other.length != this.address.length) {
            return false;
        }
        if (this.address.length == 8 || this.address.length == 32) {
            int i;
            int maskLen = this.address.length / 2;
            for (i = 0; i < maskLen; ++i) {
                byte maskedThis = (byte)(this.address[i] & this.address[i + maskLen]);
                byte maskedOther = (byte)(other[i] & other[i + maskLen]);
                if (maskedThis == maskedOther) continue;
                return false;
            }
            for (i = maskLen; i < this.address.length; ++i) {
                if (this.address[i] == other[i]) continue;
                return false;
            }
            return true;
        }
        return Arrays.equals(other, this.address);
    }

    public int hashCode() {
        int retval = 0;
        for (int i = 0; i < this.address.length; ++i) {
            retval += this.address[i] * i;
        }
        return retval;
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int constraintType;
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 7) {
            constraintType = -1;
        } else if (((IPAddressName)inputName).equals(this)) {
            constraintType = 0;
        } else {
            IPAddressName otherName = (IPAddressName)inputName;
            byte[] otherAddress = otherName.address;
            if (otherAddress.length == 4 && this.address.length == 4) {
                constraintType = 3;
            } else if (otherAddress.length == 8 && this.address.length == 8 || otherAddress.length == 32 && this.address.length == 32) {
                boolean otherSubsetOfThis = true;
                boolean thisSubsetOfOther = true;
                boolean thisEmpty = false;
                boolean otherEmpty = false;
                int maskOffset = this.address.length / 2;
                for (int i = 0; i < maskOffset; ++i) {
                    if ((byte)(this.address[i] & this.address[i + maskOffset]) != this.address[i]) {
                        thisEmpty = true;
                    }
                    if ((byte)(otherAddress[i] & otherAddress[i + maskOffset]) != otherAddress[i]) {
                        otherEmpty = true;
                    }
                    if ((byte)(this.address[i + maskOffset] & otherAddress[i + maskOffset]) != this.address[i + maskOffset] || (byte)(this.address[i] & this.address[i + maskOffset]) != (byte)(otherAddress[i] & this.address[i + maskOffset])) {
                        otherSubsetOfThis = false;
                    }
                    if ((byte)(otherAddress[i + maskOffset] & this.address[i + maskOffset]) == otherAddress[i + maskOffset] && (byte)(otherAddress[i] & otherAddress[i + maskOffset]) == (byte)(this.address[i] & otherAddress[i + maskOffset])) continue;
                    thisSubsetOfOther = false;
                }
                constraintType = thisEmpty || otherEmpty ? (thisEmpty && otherEmpty ? 0 : (thisEmpty ? 2 : 1)) : (otherSubsetOfThis ? 1 : (thisSubsetOfOther ? 2 : 3));
            } else if (otherAddress.length == 8 || otherAddress.length == 32) {
                int i;
                int maskOffset = otherAddress.length / 2;
                for (i = 0; i < maskOffset && (this.address[i] & otherAddress[i + maskOffset]) == otherAddress[i]; ++i) {
                }
                constraintType = i == maskOffset ? 2 : 3;
            } else if (this.address.length == 8 || this.address.length == 32) {
                int i;
                int maskOffset = this.address.length / 2;
                for (i = 0; i < maskOffset && (otherAddress[i] & this.address[i + maskOffset]) == this.address[i]; ++i) {
                }
                constraintType = i == maskOffset ? 1 : 3;
            } else {
                constraintType = 3;
            }
        }
        return constraintType;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not defined for IPAddressName");
    }
}

