/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractInputBuffer<S>
implements InputBuffer {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    protected Request request;
    protected MimeHeaders headers;
    protected boolean parsingHeader;
    protected boolean swallowInput;
    protected byte[] buf;
    protected int lastValid;
    protected int pos;
    protected int end;
    protected InputBuffer inputStreamInputBuffer;
    protected InputFilter[] filterLibrary;
    protected InputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected boolean rejectIllegalHeaderName;
    protected HttpParser httpParser;

    public void addFilter(InputFilter filter) {
        InputFilter[] newFilterLibrary = new InputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new InputFilter[this.filterLibrary.length];
    }

    public InputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void addActiveFilter(InputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.inputStreamInputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setRequest(this.request);
    }

    public void setSwallowInput(boolean swallowInput) {
        this.swallowInput = swallowInput;
    }

    public abstract boolean parseRequestLine(boolean var1) throws IOException;

    public abstract boolean parseHeaders() throws IOException;

    protected abstract boolean fill(boolean var1) throws IOException;

    protected abstract void init(SocketWrapper<S> var1, AbstractEndpoint<S> var2) throws IOException;

    public void recycle() {
        this.request.recycle();
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastValid = 0;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    public void nextRequest() {
        this.request.recycle();
        if (this.lastValid - this.pos > 0 && this.pos > 0) {
            System.arraycopy(this.buf, this.pos, this.buf, 0, this.lastValid - this.pos);
        }
        this.lastValid -= this.pos;
        this.pos = 0;
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    public void endRequest() throws IOException {
        if (this.swallowInput && this.lastActiveFilter != -1) {
            int extraBytes = (int)this.activeFilters[this.lastActiveFilter].end();
            this.pos -= extraBytes;
        }
    }

    public int available() {
        int result = this.lastValid - this.pos;
        if (result == 0 && this.lastActiveFilter >= 0) {
            for (int i = 0; result == 0 && i <= this.lastActiveFilter; ++i) {
                result = this.activeFilters[i].available();
            }
        }
        return result;
    }

    @Override
    public int doRead(ByteChunk chunk, Request req) throws IOException {
        if (this.lastActiveFilter == -1) {
            return this.inputStreamInputBuffer.doRead(chunk, req);
        }
        return this.activeFilters[this.lastActiveFilter].doRead(chunk, req);
    }
}

