/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.io.DirectBufferWrapper;

public class ReadWriteDirectBufferWrapper
extends DirectBufferWrapper {
    private static final Logger LOG = Logger.getInstance(ReadWriteDirectBufferWrapper.class);

    protected ReadWriteDirectBufferWrapper(File file2, long offset2, long length) {
        super(file2, offset2, length);
        assert (length <= Integer.MAX_VALUE) : length;
    }

    @Override
    protected ByteBuffer create() throws IOException {
        try (FileContext context2 = new FileContext(this.myFile);){
            RandomAccessFile file2 = context2.file;
            assert (file2 != null);
            FileChannel channel2 = file2.getChannel();
            channel2.position(this.myPosition);
            ByteBuffer buffer = ByteBuffer.allocateDirect((int)this.myLength);
            channel2.read(buffer);
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    FileContext flushWithContext(@Nullable FileContext fileContext) {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer != null && this.isDirty()) {
            try {
                if (fileContext == null) {
                    fileContext = new FileContext(this.myFile);
                }
                this.doFlush(fileContext, buffer);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
        return fileContext;
    }

    private void doFlush(FileContext fileContext, ByteBuffer buffer) throws IOException {
        RandomAccessFile file2 = fileContext.file;
        assert (file2 != null);
        FileChannel channel2 = file2.getChannel();
        channel2.position(this.myPosition);
        buffer.rewind();
        channel2.write(buffer);
        this.myDirty = false;
    }

    @Override
    public void flush() {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer != null && this.isDirty()) {
            try (FileContext context2 = new FileContext(this.myFile);){
                this.doFlush(context2, buffer);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    static class FileContext
    implements AutoCloseable {
        final RandomAccessFile file;

        FileContext(final File path2) throws IOException {
            this.file = FileUtilRt.doIOOperation(new FileUtilRt.RepeatableIOOperation<RandomAccessFile, IOException>(){
                boolean parentWasCreated;

                @Override
                @Nullable
                public RandomAccessFile execute(boolean finalAttempt) throws IOException {
                    try {
                        return new RandomAccessFile(path2, "rw");
                    }
                    catch (FileNotFoundException ex) {
                        File parentFile = path2.getParentFile();
                        if (!parentFile.exists()) {
                            if (!this.parentWasCreated) {
                                FileUtil.createDirectory(parentFile);
                                this.parentWasCreated = true;
                            } else {
                                throw new IOException("Parent directory still doesn't exist: " + path2);
                            }
                        }
                        if (!finalAttempt) {
                            return null;
                        }
                        throw ex;
                    }
                }
            });
        }

        @Override
        public void close() {
            try {
                if (this.file != null) {
                    this.file.close();
                }
            }
            catch (IOException ex) {
                LOG.error(ex);
            }
        }
    }
}

