﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/storagegateway/StorageGateway_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace StorageGateway
{
namespace Model
{
  enum class ObjectACL
  {
    NOT_SET,
    private_,
    public_read,
    public_read_write,
    authenticated_read,
    bucket_owner_read,
    bucket_owner_full_control,
    aws_exec_read
  };

namespace ObjectACLMapper
{
AWS_STORAGEGATEWAY_API ObjectACL GetObjectACLForName(const Aws::String& name);

AWS_STORAGEGATEWAY_API Aws::String GetNameForObjectACL(ObjectACL value);
} // namespace ObjectACLMapper
} // namespace Model
} // namespace StorageGateway
} // namespace Aws
