/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc.util;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.util.Util;
import com.mysql.cj.jdbc.exceptions.MysqlDataTruncation;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.io.ResultSetFactory;
import com.mysql.cj.mysqla.MysqlaSession;
import com.mysql.cj.mysqla.io.MysqlaProtocol;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;

public class ResultSetUtil {
    public static StringBuilder appendResultSetSlashGStyle(StringBuilder appendTo, ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int numFields = rsmd.getColumnCount();
        int maxWidth = 0;
        String[] fieldNames = new String[numFields];
        for (int i = 0; i < numFields; ++i) {
            fieldNames[i] = rsmd.getColumnLabel(i + 1);
            if (fieldNames[i].length() <= maxWidth) continue;
            maxWidth = fieldNames[i].length();
        }
        int rowCount = 1;
        while (rs.next()) {
            appendTo.append("*************************** ");
            appendTo.append(rowCount++);
            appendTo.append(". row ***************************\n");
            for (int i = 0; i < numFields; ++i) {
                int leftPad = maxWidth - fieldNames[i].length();
                for (int j = 0; j < leftPad; ++j) {
                    appendTo.append(" ");
                }
                appendTo.append(fieldNames[i]);
                appendTo.append(": ");
                String stringVal = rs.getString(i + 1);
                if (stringVal != null) {
                    appendTo.append(stringVal);
                } else {
                    appendTo.append("NULL");
                }
                appendTo.append("\n");
            }
            appendTo.append("\n");
        }
        return appendTo;
    }

    public static void resultSetToMap(Map mappedValues, ResultSet rs) throws SQLException {
        while (rs.next()) {
            mappedValues.put(rs.getObject(1), rs.getObject(2));
        }
    }

    public static void resultSetToMap(Map mappedValues, ResultSet rs, int key, int value) throws SQLException {
        while (rs.next()) {
            mappedValues.put(rs.getObject(key), rs.getObject(value));
        }
    }

    public static Object readObject(ResultSet resultSet, int index) throws IOException, SQLException, ClassNotFoundException {
        ObjectInputStream objIn = new ObjectInputStream(resultSet.getBinaryStream(index));
        Object obj = objIn.readObject();
        objIn.close();
        return obj;
    }

    public static SQLWarning convertShowWarningsToSQLWarnings(MysqlConnection connection) throws SQLException {
        return ResultSetUtil.convertShowWarningsToSQLWarnings(connection, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLWarning convertShowWarningsToSQLWarnings(MysqlConnection connection, int warningCountIfKnown, boolean forTruncationOnly) throws SQLException {
        Statement stmt = null;
        ResultSet warnRs = null;
        SQLWarning currentWarning = null;
        try {
            if (warningCountIfKnown < 100) {
                stmt = ((JdbcConnection)connection).createStatement();
                if (stmt.getMaxRows() != 0) {
                    stmt.setMaxRows(0);
                }
            } else {
                stmt = ((JdbcConnection)connection).createStatement(1003, 1007);
                stmt.setFetchSize(Integer.MIN_VALUE);
            }
            warnRs = stmt.executeQuery("SHOW WARNINGS");
            while (warnRs.next()) {
                int code = warnRs.getInt("Code");
                if (forTruncationOnly) {
                    if (code != 1265 && code != 1264) continue;
                    MysqlDataTruncation newTruncation = new MysqlDataTruncation(warnRs.getString("Message"), 0, false, false, 0, 0, code);
                    if (currentWarning == null) {
                        currentWarning = newTruncation;
                        continue;
                    }
                    currentWarning.setNextWarning(newTruncation);
                    continue;
                }
                String message = warnRs.getString("Message");
                SQLWarning newWarning = new SQLWarning(message, SQLError.mysqlToSqlState(code), code);
                if (currentWarning == null) {
                    currentWarning = newWarning;
                    continue;
                }
                currentWarning.setNextWarning(newWarning);
            }
            if (forTruncationOnly && currentWarning != null) {
                throw currentWarning;
            }
            SQLWarning sQLWarning = currentWarning;
            return sQLWarning;
        }
        finally {
            SQLException reThrow = null;
            if (warnRs != null) {
                try {
                    warnRs.close();
                }
                catch (SQLException sqlEx) {
                    reThrow = sqlEx;
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlEx) {
                    reThrow = sqlEx;
                }
            }
            if (reThrow != null) {
                throw reThrow;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendDeadlockStatusInformation(MysqlConnection connection, String xOpen, StringBuilder errorBuf) {
        MysqlaSession session = (MysqlaSession)connection.getSession();
        MysqlaProtocol protocol = session.getProtocol();
        if (session.getPropertySet().getBooleanReadableProperty("includeInnodbStatusInDeadlockExceptions").getValue().booleanValue() && xOpen != null && (xOpen.startsWith("40") || xOpen.startsWith("41")) && protocol.getStreamingData() == null) {
            ResultSet rs = null;
            try {
                rs = protocol.sqlQueryDirect(null, "SHOW ENGINE INNODB STATUS", session.getPropertySet().getStringReadableProperty("characterEncoding").getValue(), null, -1, false, ((JdbcConnection)connection).getCatalog(), null, session::getProfilerEventHandlerInstanceFunction, new ResultSetFactory((JdbcConnection)connection, null));
                if (rs.next()) {
                    errorBuf.append("\n\n");
                    errorBuf.append(rs.getString("Status"));
                } else {
                    errorBuf.append("\n\n");
                    errorBuf.append(Messages.getString("MysqlIO.NoInnoDBStatusFound"));
                }
            }
            catch (CJException | IOException | SQLException ex) {
                errorBuf.append("\n\n");
                errorBuf.append(Messages.getString("MysqlIO.InnoDBStatusFailed"));
                errorBuf.append("\n\n");
                errorBuf.append(Util.stackTraceToString(ex));
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        throw ExceptionFactory.createException(ex.getMessage(), ex);
                    }
                }
            }
        }
        if (session.getPropertySet().getBooleanReadableProperty("includeThreadDumpInDeadlockExceptions").getValue().booleanValue()) {
            errorBuf.append("\n\n*** Java threads running at time of deadlock ***\n\n");
            ThreadMXBean threadMBean = ManagementFactory.getThreadMXBean();
            long[] threadIds = threadMBean.getAllThreadIds();
            ThreadInfo[] threads = threadMBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
            ArrayList<ThreadInfo> activeThreads = new ArrayList<ThreadInfo>();
            for (ThreadInfo info : threads) {
                if (info == null) continue;
                activeThreads.add(info);
            }
            for (ThreadInfo threadInfo : activeThreads) {
                StackTraceElement[] stackTrace;
                errorBuf.append('\"');
                errorBuf.append(threadInfo.getThreadName());
                errorBuf.append("\" tid=");
                errorBuf.append(threadInfo.getThreadId());
                errorBuf.append(" ");
                errorBuf.append((Object)threadInfo.getThreadState());
                if (threadInfo.getLockName() != null) {
                    errorBuf.append(" on lock=" + threadInfo.getLockName());
                }
                if (threadInfo.isSuspended()) {
                    errorBuf.append(" (suspended)");
                }
                if (threadInfo.isInNative()) {
                    errorBuf.append(" (running in native)");
                }
                if ((stackTrace = threadInfo.getStackTrace()).length > 0) {
                    errorBuf.append(" in ");
                    errorBuf.append(stackTrace[0].getClassName());
                    errorBuf.append(".");
                    errorBuf.append(stackTrace[0].getMethodName());
                    errorBuf.append("()");
                }
                errorBuf.append("\n");
                if (threadInfo.getLockOwnerName() != null) {
                    errorBuf.append("\t owned by " + threadInfo.getLockOwnerName() + " Id=" + threadInfo.getLockOwnerId());
                    errorBuf.append("\n");
                }
                for (int j = 0; j < stackTrace.length; ++j) {
                    StackTraceElement ste = stackTrace[j];
                    errorBuf.append("\tat " + ste.toString());
                    errorBuf.append("\n");
                }
            }
        }
    }
}

