/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins.osgi;

import aQute.bnd.osgi.Analyzer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.osgi.ContainedVersionAnalyzer;
import org.gradle.api.internal.plugins.osgi.DefaultAnalyzerFactory;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.plugins.osgi.OsgiManifest;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.CollectionUtils;
import org.gradle.util.WrapUtil;

public class DefaultOsgiManifest
extends DefaultManifest
implements OsgiManifest {
    private String symbolicName;
    private String name;
    private String version;
    private String description;
    private String license;
    private String vendor;
    private String docURL;
    private File classesDir;
    private Factory<ContainedVersionAnalyzer> analyzerFactory = new DefaultAnalyzerFactory();
    private Map<String, List<String>> unmodelledInstructions = new HashMap<String, List<String>>();
    private FileCollection classpath;

    public DefaultOsgiManifest(FileResolver fileResolver) {
        super((PathToFileResolver)fileResolver);
    }

    public DefaultManifest getEffectiveManifest() {
        ContainedVersionAnalyzer analyzer = (ContainedVersionAnalyzer)((Object)this.analyzerFactory.create());
        DefaultManifest effectiveManifest = new DefaultManifest(null);
        try {
            long mod;
            this.setAnalyzerProperties(analyzer);
            Manifest osgiManifest = analyzer.calcManifest();
            Attributes attributes = osgiManifest.getMainAttributes();
            for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
                effectiveManifest.attributes(WrapUtil.toMap((Object)entry.getKey().toString(), (Object)((String)entry.getValue())));
            }
            effectiveManifest.attributes((Map)this.getAttributes());
            for (Map.Entry<Object, Object> entry : this.getSections().entrySet()) {
                effectiveManifest.attributes((Map)entry.getValue(), (String)entry.getKey());
            }
            if (this.classesDir != null && (mod = this.classesDir.lastModified()) > 0L) {
                effectiveManifest.getAttributes().put((Object)"Bnd-LastModified", (Object)mod);
            }
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        return this.getEffectiveManifestInternal(effectiveManifest);
    }

    private void setAnalyzerProperties(Analyzer analyzer) throws IOException {
        for (Map.Entry attribute : this.getAttributes().entrySet()) {
            String key = (String)attribute.getKey();
            if ("Manifest-Version".equals(key)) continue;
            analyzer.setProperty(key, attribute.getValue().toString());
        }
        Map<String, List<String>> instructions = this.getInstructions();
        Set<String> instructionNames = instructions.keySet();
        if (!instructionNames.contains("Import-Package")) {
            analyzer.setProperty("Import-Package", "*, !org.apache.ant.*, !org.junit.*, !org.jmock.*, !org.easymock.*, !org.mockito.*");
        }
        if (!instructionNames.contains("Bundle-Version")) {
            analyzer.setProperty("Bundle-Version", this.getVersion());
        }
        if (!instructionNames.contains("Bundle-Name")) {
            analyzer.setProperty("Bundle-Name", this.getName());
        }
        if (!instructionNames.contains("Bundle-SymbolicName")) {
            analyzer.setProperty("Bundle-SymbolicName", this.getSymbolicName());
        }
        if (!instructionNames.contains("Export-Package")) {
            analyzer.setProperty("Export-Package", "*;-noimport:=false;version=" + this.getVersion());
        }
        for (String instructionName : instructionNames) {
            String list = this.createPropertyStringFromList(this.instructionValue(instructionName));
            if (list == null || list.length() <= 0) continue;
            analyzer.setProperty(instructionName, list);
        }
        analyzer.setJar(this.getClassesDir());
        analyzer.setClasspath(this.getClasspath().getFiles().toArray(new File[0]));
    }

    @Override
    public List<String> instructionValue(String instructionName) {
        if (instructionName.equals("Bundle-SymbolicName")) {
            return this.createListFromPropertyString(this.getSymbolicName());
        }
        if (instructionName.equals("Bundle-Name")) {
            return this.createListFromPropertyString(this.getName());
        }
        if (instructionName.equals("Bundle-Version")) {
            return this.createListFromPropertyString(this.getVersion());
        }
        if (instructionName.equals("Bundle-Description")) {
            return this.createListFromPropertyString(this.getDescription());
        }
        if (instructionName.equals("Bundle-License")) {
            return this.createListFromPropertyString(this.getLicense());
        }
        if (instructionName.equals("Bundle-Vendor")) {
            return this.createListFromPropertyString(this.getVendor());
        }
        if (instructionName.equals("Bundle-DocURL")) {
            return this.createListFromPropertyString(this.getDocURL());
        }
        return this.unmodelledInstructions.get(instructionName);
    }

    @Override
    public OsgiManifest instruction(String name, String ... values) {
        if (!this.maybeAppendModelledInstruction(name, values)) {
            if (this.unmodelledInstructions.get(name) == null) {
                this.unmodelledInstructions.put(name, new ArrayList());
            }
            this.unmodelledInstructions.get(name).addAll(Arrays.asList(values));
        }
        return this;
    }

    private String appendValues(String existingValues, String ... toPrepend) {
        List<String> parts = this.createListFromPropertyString(existingValues);
        if (parts == null) {
            return this.createPropertyStringFromArray(toPrepend);
        }
        parts.addAll(Arrays.asList(toPrepend));
        return this.createPropertyStringFromList(parts);
    }

    private boolean maybeAppendModelledInstruction(String name, String ... values) {
        if (name.equals("Bundle-SymbolicName")) {
            this.setSymbolicName(this.appendValues(this.getSymbolicName(), values));
            return true;
        }
        if (name.equals("Bundle-Name")) {
            this.setName(this.appendValues(this.getName(), values));
            return true;
        }
        if (name.equals("Bundle-Version")) {
            this.setVersion(this.appendValues(this.getVersion(), values));
            return true;
        }
        if (name.equals("Bundle-Description")) {
            this.setDescription(this.appendValues(this.getDescription(), values));
            return true;
        }
        if (name.equals("Bundle-License")) {
            this.setLicense(this.appendValues(this.getLicense(), values));
            return true;
        }
        if (name.equals("Bundle-Vendor")) {
            this.setVendor(this.appendValues(this.getVendor(), values));
            return true;
        }
        if (name.equals("Bundle-DocURL")) {
            this.setDocURL(this.appendValues(this.getDocURL(), values));
            return true;
        }
        return false;
    }

    @Override
    public OsgiManifest instructionFirst(String name, String ... values) {
        if (!this.maybePrependModelledInstruction(name, values)) {
            if (this.unmodelledInstructions.get(name) == null) {
                this.unmodelledInstructions.put(name, new ArrayList());
            }
            this.unmodelledInstructions.get(name).addAll(0, Arrays.asList(values));
        }
        return this;
    }

    private String prependValues(String existingValues, String ... toPrepend) {
        List<String> parts = this.createListFromPropertyString(existingValues);
        if (parts == null) {
            return this.createPropertyStringFromArray(toPrepend);
        }
        parts.addAll(0, Arrays.asList(toPrepend));
        return this.createPropertyStringFromList(parts);
    }

    private boolean maybePrependModelledInstruction(String name, String ... values) {
        if (name.equals("Bundle-SymbolicName")) {
            this.setSymbolicName(this.prependValues(this.getSymbolicName(), values));
            return true;
        }
        if (name.equals("Bundle-Name")) {
            this.setName(this.prependValues(this.getName(), values));
            return true;
        }
        if (name.equals("Bundle-Version")) {
            this.setVersion(this.prependValues(this.getVersion(), values));
            return true;
        }
        if (name.equals("Bundle-Description")) {
            this.setDescription(this.prependValues(this.getDescription(), values));
            return true;
        }
        if (name.equals("Bundle-License")) {
            this.setLicense(this.prependValues(this.getLicense(), values));
            return true;
        }
        if (name.equals("Bundle-Vendor")) {
            this.setVendor(this.prependValues(this.getVendor(), values));
            return true;
        }
        if (name.equals("Bundle-DocURL")) {
            this.setDocURL(this.prependValues(this.getDocURL(), values));
            return true;
        }
        return false;
    }

    @Override
    public OsgiManifest instructionReplace(String name, String ... values) {
        if (!this.maybeSetModelledInstruction(name, values)) {
            if (values.length == 0 || values.length == 1 && values[0] == null) {
                this.unmodelledInstructions.remove(name);
            } else {
                if (this.unmodelledInstructions.get(name) == null) {
                    this.unmodelledInstructions.put(name, new ArrayList());
                }
                List<String> instructionsForName = this.unmodelledInstructions.get(name);
                instructionsForName.clear();
                Collections.addAll(instructionsForName, values);
            }
        }
        return this;
    }

    private boolean maybeSetModelledInstruction(String name, String ... values) {
        if (name.equals("Bundle-SymbolicName")) {
            this.setSymbolicName(this.createPropertyStringFromArray(values));
            return true;
        }
        if (name.equals("Bundle-Name")) {
            this.setName(this.createPropertyStringFromArray(values));
            return true;
        }
        if (name.equals("Bundle-Version")) {
            this.setVersion(this.createPropertyStringFromArray(values));
            return true;
        }
        if (name.equals("Bundle-Description")) {
            this.setDescription(this.createPropertyStringFromArray(values));
            return true;
        }
        if (name.equals("Bundle-License")) {
            this.setLicense(this.createPropertyStringFromArray(values));
            return true;
        }
        if (name.equals("Bundle-Vendor")) {
            this.setVendor(this.createPropertyStringFromArray(values));
            return true;
        }
        if (name.equals("Bundle-DocURL")) {
            this.setDocURL(this.createPropertyStringFromArray(values));
            return true;
        }
        return false;
    }

    @Override
    public Map<String, List<String>> getInstructions() {
        HashMap<String, List<String>> instructions = new HashMap<String, List<String>>();
        instructions.putAll(this.unmodelledInstructions);
        instructions.putAll(this.getModelledInstructions());
        return instructions;
    }

    private String createPropertyStringFromArray(String ... valueList) {
        return this.createPropertyStringFromList(Arrays.asList(valueList));
    }

    private String createPropertyStringFromList(List<String> valueList) {
        return valueList == null || valueList.isEmpty() ? null : CollectionUtils.join((String)",", valueList);
    }

    private List<String> createListFromPropertyString(String propertyString) {
        return propertyString == null || propertyString.length() == 0 ? null : new LinkedList<String>(Arrays.asList(propertyString.split(",")));
    }

    private Map<String, List<String>> getModelledInstructions() {
        HashMap<String, List<String>> modelledInstructions = new HashMap<String, List<String>>();
        modelledInstructions.put("Bundle-SymbolicName", this.createListFromPropertyString(this.symbolicName));
        modelledInstructions.put("Bundle-Name", this.createListFromPropertyString(this.name));
        modelledInstructions.put("Bundle-Version", this.createListFromPropertyString(this.version));
        modelledInstructions.put("Bundle-Description", this.createListFromPropertyString(this.description));
        modelledInstructions.put("Bundle-License", this.createListFromPropertyString(this.license));
        modelledInstructions.put("Bundle-Vendor", this.createListFromPropertyString(this.vendor));
        modelledInstructions.put("Bundle-DocURL", this.createListFromPropertyString(this.docURL));
        return CollectionUtils.filter(modelledInstructions, (Spec)new Spec<Map.Entry<String, List<String>>>(){

            public boolean isSatisfiedBy(Map.Entry<String, List<String>> element) {
                return element.getValue() != null;
            }
        });
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLicense() {
        return this.license;
    }

    @Override
    public void setLicense(String license) {
        this.license = license;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @Override
    public String getDocURL() {
        return this.docURL;
    }

    @Override
    public void setDocURL(String docURL) {
        this.docURL = docURL;
    }

    @Override
    public File getClassesDir() {
        return this.classesDir;
    }

    @Override
    public void setClassesDir(File classesDir) {
        this.classesDir = classesDir;
    }

    @Override
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    public Factory<ContainedVersionAnalyzer> getAnalyzerFactory() {
        return this.analyzerFactory;
    }

    public void setAnalyzerFactory(Factory<ContainedVersionAnalyzer> analyzerFactory) {
        this.analyzerFactory = analyzerFactory;
    }
}

