#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: statistics
version: 0.14.0.2
id: statistics-0.14.0.2-DHOGSRQojy59OEUmlNimDy
key: statistics-0.14.0.2-DHOGSRQojy59OEUmlNimDy
license: BSD-2-Clause
copyright: 2009-2014 Bryan O'\''Sullivan
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
author: Bryan O'\''Sullivan <bos@serpentine.com>
homepage: https://github.com/bos/statistics
synopsis: A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.
    .
    The library'\''s facilities can be divided into four broad categories:
    .
    * Working with widely used discrete and continuous probability
    distributions.  (There are dozens of exotic distributions in use;
    we focus on the most common.)
    .
    * Computing with sample data: quantile estimation, kernel density
    estimation, histograms, bootstrap methods, significance testing,
    and regression and autocorrelation analysis.
    .
    * Random variate generation under several different distributions.
    .
    * Common statistical tests for significant differences between
    samples.
category: Math, Statistics
abi: f55bd6102b9705879548d56c15f3cfcc
exposed: True
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Normal
    Statistics.Distribution.Poisson Statistics.Distribution.StudentT
    Statistics.Distribution.Transform Statistics.Distribution.Uniform
    Statistics.Function Statistics.Math.RootFinding Statistics.Matrix
    Statistics.Matrix.Algorithms Statistics.Matrix.Mutable
    Statistics.Matrix.Types Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Powers
    Statistics.Test.ChiSquared Statistics.Test.KolmogorovSmirnov
    Statistics.Test.KruskalWallis Statistics.Test.MannWhitneyU
    Statistics.Test.StudentT Statistics.Test.Types
    Statistics.Test.WilcoxonT Statistics.Transform Statistics.Types
hidden-modules: Statistics.Distribution.Poisson.Internal
                Statistics.Function.Comparison Statistics.Internal
                Statistics.Sample.Internal Statistics.Test.Internal
                Statistics.Types.Internal
import-dirs: /usr/lib/ghc-8.6.1/site-local/statistics-0.14.0.2
library-dirs: /usr/lib/ghc-8.6.1/site-local/statistics-0.14.0.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.6.1/statistics-0.14.0.2
hs-libraries: HSstatistics-0.14.0.2-DHOGSRQojy59OEUmlNimDy
depends:
    aeson-1.4.1.0-8dof3cdgEra8LhpTdWgCQb base-4.12.0.0
    base-orphans-0.8-MvDA9MxK5e7YBvQaNB0jM binary-0.8.6.0
    deepseq-1.4.4.0 erf-2.0.0.0-ExhHoenPosmHlOroBQQced
    math-functions-0.3.0.2-LhI2u4R1Sf7EpQbf7OyAjE
    monad-par-0.3.4.8-F8ipVZU0l3UKxMCLfhh6u0
    mwc-random-0.14.0.0-CHYtJffaTqvHIHYnw7lP6P
    primitive-0.6.4.0-1mvPxVOk6Q6KOkWCZxqESf
    vector-0.12.0.1-BKWaeB2IPwRDyZEP11mv5m
    vector-algorithms-0.8.0.1-8UKwWk9wVx92hjm80ynV3Z
    vector-binary-instances-0.2.5.1-IQaUNlPskFJ1IdtNmjl3KM
    vector-th-unbox-0.2.1.6-J8CuseO2OKiARtdHxtybxq
haddock-interfaces: /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html: /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

