/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.MyPoint2D;
import net.sourceforge.plantuml.cute.RotationZoom;
import net.sourceforge.plantuml.cute.Segment;
import net.sourceforge.plantuml.cute.Tension;

public class Arc {
    private final Segment segment;
    private final Tension tension;

    public Tension getTension() {
        return this.tension;
    }

    public Arc(MyPoint2D a, MyPoint2D b) {
        this(a, b, Tension.none());
    }

    private Arc(MyPoint2D a, MyPoint2D b, Tension tension) {
        this.segment = new Segment(a, b);
        this.tension = tension;
    }

    public MyPoint2D getA() {
        return (MyPoint2D)this.segment.getA();
    }

    public MyPoint2D getB() {
        return (MyPoint2D)this.segment.getB();
    }

    public Arc withNoTension() {
        return new Arc(this.getA(), this.getB(), Tension.none());
    }

    public Arc withTension(String tensionString) {
        if (tensionString == null) {
            return this;
        }
        double newTension = Double.parseDouble(tensionString);
        return new Arc(this.getA(), this.getB(), new Tension(newTension));
    }

    public Arc rotateZoom(RotationZoom rotationZoom) {
        return new Arc(this.getA().rotateZoom(rotationZoom), this.getB().rotateZoom(rotationZoom), this.tension.rotateZoom(rotationZoom));
    }

    public Point2D getTensionPoint() {
        if (this.tension.isNone()) {
            throw new IllegalArgumentException();
        }
        return this.segment.getOrthoPoint(-this.tension.getValue());
    }

    public double getLength() {
        return this.segment.getLength();
    }
}

