/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineInstrumented;

public class ReadLineReader
extends ReadLineInstrumented
implements ReadLine {
    private final BufferedReader br;
    private LineLocationImpl location;
    private final String description;

    private ReadLineReader(Reader reader, String description, LineLocation parent) {
        if (description == null) {
            description = "?";
        }
        this.br = new BufferedReader(reader);
        this.location = new LineLocationImpl(description, parent);
        this.description = description;
        Log.info("Reading from " + description);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.description;
    }

    private ReadLineReader(Reader reader, String desc) {
        this(reader, desc, null);
    }

    public static ReadLine create(Reader reader, String description) {
        return new ReadLineReader(reader, description, null);
    }

    public static ReadLine create(Reader reader, String description, LineLocation parent) {
        return new ReadLineReader(reader, description, parent);
    }

    @Override
    StringLocated readLineInst() throws IOException {
        String s = this.br.readLine();
        this.location = this.location.oneLineRead();
        if (s == null) {
            return null;
        }
        if (s.startsWith("\ufeff")) {
            s = s.substring(1);
        }
        s = s.replace('\u2013', '-');
        return new StringLocated(s, this.location);
    }

    @Override
    void closeInst() throws IOException {
        this.br.close();
    }
}

