A.16 How to Practice Live Coding

# 8 Tips for Live Coding Practice

Last month we took a look at five important techniques for mastering
live coding - in other words, we explored how we could use Sonic Pi to
approach code in the same way we would approach a musical instrument. One
of the important concepts that we discussed was practice. This month
we're going to take a deeper dive into understanding why live coding
practice is important and how you might start.


## Practice regularly

The most important piece of advice is to make sure you practice
regularly. As a rule I typically practice for 1-2 hours a day, but 20
mins is just fine when you're starting out. Little but often is what
you're aiming for - so if you can only manage 10 minutes, that's a great
start.

Practice tip #1 - start to develop a practice routine. Find a nice time
in the day that works for you and try and practice at that time as many
days of the week as you can. Before long you'll be looking forward to your
regular session.


## Learn to Touch Type

If you watch a professional musician performing on stage you'll likely
notice a few things. Firstly, when they play they don't stare at their
instrument. Their fingers, arms and bodies know which keys to press,
strings to pluck or drums to hit without them having to think about it
too much. This is known as "muscle memory" and although it might sound
like something only professionals can do - it's just the same as when
you first learned to walk or ride a bike - practicing through
repetition. Live coders use muscle memory to free their minds from
having to think about where to move their fingers so they can focus on
the music. This is called touch-typing - typing without having to look
at the keyboard.

Practice tip #2 - learn how to touch type. There are many apps, websites
and even games which can help you achieve this. Find one you like the
look of and stick at it until you can code without looking down.


## Code whilst standing

The body of a musician is conditioned for playing their instrument. For
example, a trumpet player needs to be able to blow hard, a guitar player
needs to be able to grip the fretboard with strength and a drummer needs
to be able to continually hit the drums for long periods of time. So,
what's physical about live coding? Just like DJs, live coders typically
perform whilst standing up and some even dance whilst they code! If you
practice live coding whilst sitting at a desk and then have to get up
and stand at a gig, you'll likely find the difference very difficult and
frustrating.

Practice tip #3 - stand whilst you practice. The easiest way to do this
is to use a standing height desk. However, if like me you don't have one
at home, there's a couple of low-fi options. The approach I take is to
use an ironing board which happens to work rather well. Another is to
stack some boxes or large books on a normal desk and place your keyboard
on top of that. Also, make sure you stretch before you start practicing
and try and dance a little during the session. Remember, nobody is
watching you, so have fun and you'll feel much more natural on stage.


## Practice setting up

Most instruments require some assembly and tuning before they can be
played. Unless you're a rockstar with a bus full of roadies, you'll have
to set up your own instrument before your gig. This is often a stressful
time and it is easy for problems to occur. One way to help with this is
to incorporate the setup process into your practice sessions.

Practice tip #4 - treat setting up as an important part of your
practice. For example, have a box or bag that you can keep your
Raspberry Pi and keyboard in etc. Before each practice session, take out
all the parts, connect everything, and work through the boot process
until you have Sonic Pi running and can make sounds. Once you've
finished practicing, take the time to carefully pack everything away
afterwards. This may take some time at first, but before long you'll be
able to setup and pack everything away incredibly quickly without having
to think about it.


## Experiment Musically

Once you've set up and are ready to start making music, you might find
yourself struggling to know where to start.  One problem many people
face is that they might have a good idea of the kinds of sounds they
want to make, but are frustrated that they can't produce them. Some
people don't even know what kind of sounds they want to make! The first
thing to do is not to worry - this is very common and happens to every
musician - even if they've been practicing for a long time. It is much
more important to be making sounds you don't like than not making any
sounds at all.

Practice tip #5 - spend time making sounds and music you don't like. Try
to make time to explore new sounds and ideas. Don't worry that it might
sound terrible if it's not the style you're looking for. When you're
experimenting like this you increase the chance of stumbling over a
sound or combination of sounds which you love! Even if 99% of the sounds
you make are bad, that 1% might be the riff or intro to your new
track. Forget the things you don't like and remember the parts you
do. This is even easier when you're making music with code - just hit
save!


## Hear the Code

Many musicians can look at a musical score and hear the music in their
head without having to play it. This is a very useful skill and it's
well worth incorporating into your live coding practice sessions. The
imporant point is to be able to have some understanding of what the code
is going to sound like. You don't need to be able to hear it exactly in
your head, but instead it's useful to know if the code is going to be
fast, slow, loud, rhythmic, melodic, random, etc. The final goal is then
to be able to reverse this process - to be able to hear music in your
head and know what code to write to make it. It may take you a long time
to master this, but once you do, you'll be able to improvise on stage
and express your ideas fluently.

Practice tip #6 - write some code into Sonic Pi but don't hit the Run
button. Instead, try to imagine what sound it is going to produce. Then,
hit Run, listen, and think about what you got right and what you
didn't. Keep repeating this until it become a natural part of your
coding process. When I practice I normally have a good idea of what the
code will sound like. However, I still am occasionally surprised, and
then I'll stop and spend some time thinking about why I was wrong. Each
time this happens, I learn new tricks which allow me to express myself
in new ways.

## Remove all distractions

A common problem when practicing is to become distracted with other
things. Practicing is hard and requires real discipline regardless of
the kind of music you're making - from jazz to classical to EDM. If
you're struggling to get started or make progress, it's often too easy
to hop on social media, or look something up on the internet etc. If
you've set yourself a target of 20 minutes of practice, it's important
to try and spend all that time being as productive as possible.

Practice tip #7 - before you start practicing remove as many
distractions as possible. For example, disconnect from the internet, put
your phone in another room and try to practice in a quiet place where
you're unlikely to be disturbed. Try to focus on coding music and you
can return to your distractions when you've finished.


## Keep a practice diary

When you are practicing, you'll often find your mind is full of new
exciting ideas - new musical directions, new sounds to try out, new
functions to write, etc. These ideas are often so interesting that you
might stop what you're doing and start working on the idea. This is
another form of distraction!

Practice tip #8 - keep a practice diary by your keyboard. When you get
an exciting new idea, temporarily pause your practice session, quickly
jot the idea down, then forget about it and carry on practicing. You can
then spend some quality time thinking about and working on your ideas
after you've finished practicing.


## Bringing it all together

Try to establish a practice routine which incorporates as many of these
ideas as possible. Try to keep the sessions as fun as possible but be
aware that some practice sessions will be hard and feel a little like
work. However, it will all be worth it once you've created your first
piece or given your first performance. Remember, practice is the key to
success!
