# frozen_string_literal: true

module WPScan
  # Specific implementation
  class Vulnerability < CMSScanner::Vulnerability
    include References

    # @param [ Hash ] json_data
    # @return [ Vulnerability ]
    def self.load_from_json(json_data)
      references = { wpvulndb: json_data['id'].to_s }

      if json_data['references']
        references_keys.each do |key|
          references[key] = json_data['references'][key.to_s] if json_data['references'].key?(key.to_s)
        end
      end

      new(
        json_data['title'],
        references,
        json_data['vuln_type'],
        json_data['fixed_in']
      )
    end
  end
end
