/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_yo_BJ extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "Osh\u00f9 Sh\u025b\u0301r\u025b\u0301",
               "Osh\u00f9 \u00c8r\u00e8l\u00e8",
               "Osh\u00f9 \u0190r\u025b\u0300n\u00e0",
               "Osh\u00f9 \u00ccgb\u00e9",
               "Osh\u00f9 \u0190\u0300bibi",
               "Osh\u00f9 \u00d2k\u00fadu",
               "Osh\u00f9 Ag\u025bm\u0254",
               "Osh\u00f9 \u00d2g\u00fan",
               "Osh\u00f9 Owewe",
               "Osh\u00f9 \u0186\u0300w\u00e0r\u00e0",
               "Osh\u00f9 B\u00e9l\u00fa",
               "Osh\u00f9 \u0186\u0300p\u025b\u0300",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "Sh\u025b\u0301r",
               "\u00c8r\u00e8l",
               "\u0190r\u025b\u0300n",
               "\u00ccgb",
               "\u0190\u0300bi",
               "\u00d2k\u00fa",
               "Ag\u025b",
               "\u00d2g\u00fa",
               "Owe",
               "\u0186\u0300w\u00e0",
               "B\u00e9l",
               "\u0186\u0300p\u025b",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "S",
               "\u00c8",
               "\u0190",
               "\u00cc",
               "\u0190\u0300",
               "\u00d2",
               "A",
               "\u00d2",
               "O",
               "\u0186\u0300",
               "B",
               "\u0186\u0300",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u0186j\u0254\u0301 \u00c0\u00eck\u00fa",
               "\u0186j\u0254\u0301 Aj\u00e9",
               "\u0186j\u0254\u0301 \u00ccs\u025b\u0301gun",
               "\u0186j\u0254\u0301r\u00fa",
               "\u0186j\u0254\u0301b\u0254",
               "\u0186j\u0254\u0301 \u0190t\u00ec",
               "\u0186j\u0254\u0301 \u00c0b\u00e1m\u025b\u0301ta",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\u00c0\u00eck",
               "Aj",
               "\u00ccs\u025b\u0301g",
               "\u0186j\u0254\u0301r",
               "\u0186j\u0254\u0301b",
               "\u0190t",
               "\u00c0b\u00e1m",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "\u00c0",
               "A",
               "\u00cc",
               "\u0186",
               "\u0186",
               "\u0190",
               "\u00c0",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "\u00ccd\u00e1m\u025b\u0301rin k\u00edn\u00ed",
               "\u00ccd\u00e1m\u025b\u0301rin Kej\u00ec",
               "\u00ccd\u00e1m\u025b\u0301rin K\u025bta",
               "\u00ccd\u00e1m\u025b\u0301rin K\u025brin",
            };
        final String[] metaValue_QuarterNarrows = new String[] {
               "k\u00edn\u00ed",
               "Kej\u00ec",
               "K\u025bta",
               "K\u025bin",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "\u00c0\u00e1r\u0254\u0300",
               "\u0186\u0300s\u00e1n",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "HH:mm:ss zzzz",
               "H:mm:ss z",
               "H:m:s",
               "H:m",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "EEEE, d MM y G",
               "d MM y G",
               "d MM y G",
               "dd/MM/y G",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE, d MM y GGGG",
               "d MM y GGGG",
               "d MM y GGGG",
               "dd/MM/y GGGG",
            };
        final String metaValue_calendarname_gregorian = "K\u00e0l\u025b\u0301\u0144d\u00e0 Gregory";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\u0186d\u00fan" },
            { "islamic.QuarterAbbreviations", metaValue_QuarterNames },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "standalone.DayNarrows", metaValue_DayNarrows },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_QuarterNames },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "japanese.QuarterAbbreviations", metaValue_QuarterNames },
            { "islamic.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "japanese.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "roc.DayNames", metaValue_DayNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "standalone.QuarterNarrows",
                new String[] {
                    "k\u00ed",
                    "Ke",
                    "K\u025bt",
                    "K\u025br",
                }
            },
            { "roc.QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "field.weekday", "\u0186j\u0254\u0301 t\u00f3 w\u00e0 l\u00e1\u00e0\u00e1r\u00edn \u0254\u0300s\u025b\u0300" },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\u00ccs\u025b\u0301j\u00fa" },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "\u00c0\u00e1r\u0254\u0300/\u0254\u0300s\u00e1n" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterNames },
            { "japanese.QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_QuarterNames },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "field.second", "\u00ccs\u025b\u0301j\u00fa \u00c0\u00e0y\u00e1" },
            { "roc.MonthNames", metaValue_MonthNames },
            { "field.week", "\u0186\u0300s\u025b\u0300" },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "\u00a4#,##0.00",
                    "#,##0%",
                }
            },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "timezone.regionFormat.daylight", "{0} \u00c0k\u00f3k\u00f2 oj\u00fam\u0254m\u0254" },
            { "DatePatterns",
                new String[] {
                    "EEEE, d MMM y",
                    "d MMM y",
                    "d MM y",
                    "d/M/y",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames",
                new String[] {
                    "\u00c0\u00eck\u00fa",
                    "Aj\u00e9",
                    "\u00ccs\u025b\u0301gun",
                    "\u0186j\u0254\u0301r\u00fa",
                    "\u0186j\u0254\u0301b\u0254",
                    "\u0190t\u00ec",
                    "\u00c0b\u00e1m\u025b\u0301ta",
                }
            },
            { "japanese.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthNames",
                new String[] {
                    "Sh\u025b\u0301r\u025b\u0301",
                    "\u00c8r\u00e8l\u00e8",
                    "\u0190r\u025b\u0300n\u00e0",
                    "\u00ccgb\u00e9",
                    "\u0190\u0300bibi",
                    "\u00d2k\u00fadu",
                    "Ag\u025bm\u0254",
                    "\u00d2g\u00fan",
                    "Owewe",
                    "\u0186\u0300w\u00e0r\u00e0",
                    "B\u00e9l\u00fa",
                    "\u0186\u0300p\u025b\u0300",
                    "",
                }
            },
            { "standalone.MonthAbbreviations",
                new String[] {
                    "Sh\u025b\u0301",
                    "\u00c8r",
                    "\u0190r",
                    "\u00ccg",
                    "\u0190\u0300b",
                    "\u00d2k",
                    "Ag",
                    "\u00d2g",
                    "Ow",
                    "\u0186\u0300w",
                    "B\u00e9",
                    "\u0186\u0300p",
                    "",
                }
            },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "buddhist.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "QuarterAbbreviations", metaValue_QuarterNames },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "roc.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
