/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.data.preferences.sources.MapPaintPrefHelper;
import org.openstreetmap.josm.data.preferences.sources.PresetPrefHelper;
import org.openstreetmap.josm.data.preferences.sources.SourcePrefHelper;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.bugreport.DebugTextDisplay;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReportSender;

public final class ShowStatusReportAction
extends JosmAction {
    public ShowStatusReportAction() {
        super(I18n.tr("Show Status Report", new Object[0]), "clock", I18n.tr("Show status report with useful information that can be attached to bugs", new Object[0]), Shortcut.registerShortcut("help:showstatusreport", I18n.tr("Help: {0}", I18n.tr("Show Status Report", new Object[0])), 65535, 5000), false);
        this.setHelpId(HelpUtil.ht("/Action/ShowStatusReport"));
        this.putValue("toolbar", "help/showstatusreport");
        MainApplication.getToolbar().register(this);
    }

    public static String getReportHeader() {
        DataSet dataset;
        StringBuilder text = new StringBuilder(256);
        String runtimeVersion = Utils.getSystemProperty("java.runtime.version");
        text.append(Version.getInstance().getReleaseAttributes()).append("\nIdentification: ").append(Version.getInstance().getAgentString());
        String buildNumber = PlatformManager.getPlatform().getOSBuildNumber();
        if (!buildNumber.isEmpty()) {
            text.append("\nOS Build number: ").append(buildNumber);
        }
        text.append("\nMemory Usage: ").append(Runtime.getRuntime().totalMemory() / 1024L / 1024L).append(" MB / ").append(Runtime.getRuntime().maxMemory() / 1024L / 1024L).append(" MB (").append(Runtime.getRuntime().freeMemory() / 1024L / 1024L).append(" MB allocated, but free)\nJava version: ").append(runtimeVersion != null ? runtimeVersion : Utils.getSystemProperty("java.version")).append(", ").append(Utils.getSystemProperty("java.vendor")).append(", ").append(Utils.getSystemProperty("java.vm.name")).append("\nScreen: ");
        if (!GraphicsEnvironment.isHeadless()) {
            text.append(Arrays.stream(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()).map(gd -> {
                StringBuilder b = new StringBuilder(gd.getIDstring());
                DisplayMode dm = gd.getDisplayMode();
                if (dm != null) {
                    b.append(' ').append(dm.getWidth()).append('x').append(dm.getHeight());
                }
                return b.toString();
            }).collect(Collectors.joining(", ")));
        }
        Dimension maxScreenSize = GuiHelper.getMaximumScreenSize();
        text.append("\nMaximum Screen Size: ").append((int)maxScreenSize.getWidth()).append('x').append((int)maxScreenSize.getHeight()).append('\n');
        if (PlatformManager.isPlatformUnixoid()) {
            String atkWrapperDetails;
            String webStartDetails;
            PlatformHookUnixoid platform = (PlatformHookUnixoid)PlatformManager.getPlatform();
            String packageDetails = platform.getJavaPackageDetails();
            if (packageDetails != null) {
                text.append("Java package: ").append(packageDetails).append('\n');
            }
            if (Utils.isRunningJavaWebStart() && (webStartDetails = platform.getWebStartPackageDetails()) != null) {
                text.append("WebStart package: ").append(webStartDetails).append('\n');
            }
            if ((atkWrapperDetails = platform.getAtkWrapperPackageDetails()) != null) {
                text.append("Java ATK Wrapper package: ").append(atkWrapperDetails).append('\n');
            }
            for (String p : new String[]{"apache-commons-compress", "libcommons-compress-java", "apache-commons-jcs-core", "apache-commons-logging", "libcommons-logging-java", "fonts-noto", "jsonp", "metadata-extractor2", "signpost-core", "liboauth-signpost-java", "svgsalamander"}) {
                String details = PlatformHookUnixoid.getPackageDetails(p);
                if (details == null) continue;
                text.append(p).append(": ").append(details).append('\n');
            }
        }
        try {
            ArrayList<String> vmArguments = new ArrayList<String>(ManagementFactory.getRuntimeMXBean().getInputArguments());
            ListIterator<String> it = vmArguments.listIterator();
            while (it.hasNext()) {
                String value = (String)it.next();
                if (value.contains("=")) {
                    String[] param = value.split("=", 2);
                    if (param[0].toLowerCase(Locale.ENGLISH).startsWith("-dproxy")) {
                        it.set(param[0] + "=xxx");
                        continue;
                    }
                    if ("-Djnlpx.vmargs".equals(param[0])) {
                        it.remove();
                        continue;
                    }
                    String val = ShowStatusReportAction.paramCleanup(param[1]);
                    if (val.equals(param[1])) continue;
                    it.set(param[0] + '=' + val);
                    continue;
                }
                if (!value.startsWith("-X")) continue;
                it.remove();
            }
            if (!vmArguments.isEmpty()) {
                text.append("VM arguments: ").append(((Object)vmArguments).toString().replace("\\\\", "\\")).append('\n');
            }
        }
        catch (SecurityException e) {
            Logging.trace(e);
        }
        List<String> commandLineArgs = MainApplication.getCommandLineArgs();
        if (!commandLineArgs.isEmpty()) {
            text.append("Program arguments: ").append(Arrays.toString(ShowStatusReportAction.paramCleanup(commandLineArgs).toArray())).append('\n');
        }
        if ((dataset = MainApplication.getLayerManager().getActiveDataSet()) != null) {
            String result = DatasetConsistencyTest.runTests(dataset);
            if (result.isEmpty()) {
                text.append("Dataset consistency test: No problems found\n");
            } else {
                text.append("\nDataset consistency test:\n").append(result).append('\n');
            }
        }
        text.append('\n');
        ShowStatusReportAction.appendCollection(text, "Plugins", Utils.transform(PluginHandler.getBugReportInformation(), i -> "+ " + i));
        ShowStatusReportAction.appendCollection(text, "Tagging presets", ShowStatusReportAction.getCustomUrls(PresetPrefHelper.INSTANCE));
        ShowStatusReportAction.appendCollection(text, "Map paint styles", ShowStatusReportAction.getCustomUrls(MapPaintPrefHelper.INSTANCE));
        ShowStatusReportAction.appendCollection(text, "Validator rules", ShowStatusReportAction.getCustomUrls(ValidatorPrefHelper.INSTANCE));
        ShowStatusReportAction.appendCollection(text, "Last errors/warnings", Utils.transform(Logging.getLastErrorAndWarnings(), i -> "- " + i));
        String osmApi = OsmApi.getOsmApi().getServerUrl();
        if (!Config.getUrls().getDefaultOsmApiUrl().equals(osmApi.trim())) {
            text.append("OSM API: ").append(osmApi).append("\n\n");
        }
        return text.toString();
    }

    private static Collection<String> getCustomUrls(SourcePrefHelper helper) {
        Set defaultUrls = helper.getDefault().stream().map(i -> i.url).collect(Collectors.toSet());
        return helper.get().stream().filter(i -> !defaultUrls.contains(i.url)).map(i -> (i.active ? "+ " : "- ") + i.url).collect(Collectors.toList());
    }

    private static List<String> paramCleanup(Collection<String> params) {
        ArrayList<String> result = new ArrayList<String>(params.size());
        for (String param : params) {
            result.add(ShowStatusReportAction.paramCleanup(param));
        }
        return result;
    }

    static Map<String, String> getAnonimicDirectorySymbolMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(PlatformManager.isPlatformWindows() ? "%JAVA_HOME%" : "${JAVA_HOME}", Utils.getSystemEnv("JAVA_HOME"));
        map.put("<java.home>", Utils.getSystemProperty("java.home"));
        map.put("<josm.pref>", Config.getDirs().getPreferencesDirectory(false).toString());
        map.put("<josm.userdata>", Config.getDirs().getUserDataDirectory(false).toString());
        map.put("<josm.cache>", Config.getDirs().getCacheDirectory(false).toString());
        map.put(PlatformManager.isPlatformWindows() ? "%UserProfile%" : "${HOME}", Utils.getSystemProperty("user.home"));
        return map;
    }

    static String paramCleanup(String param) {
        String userName = Utils.getSystemProperty("user.name");
        String userNameAlt = "<user.name>";
        String val = param;
        for (Map.Entry<String, String> entry : ShowStatusReportAction.getAnonimicDirectorySymbolMap().entrySet()) {
            val = ShowStatusReportAction.paramReplace(val, entry.getValue(), entry.getKey());
        }
        if (userName != null && userName.length() >= 3) {
            val = ShowStatusReportAction.paramReplace(val, userName, "<user.name>");
        }
        return val;
    }

    private static String paramReplace(String str, String target, String replacement) {
        return target == null ? str : str.replace(target, replacement);
    }

    private static void appendCollection(StringBuilder text, String label, Collection<String> col) {
        if (!col.isEmpty()) {
            text.append(label).append(":\n");
            for (String o : col) {
                text.append(ShowStatusReportAction.paramCleanup(o)).append('\n');
            }
            text.append('\n');
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StringBuilder text = new StringBuilder();
        String reportHeader = ShowStatusReportAction.getReportHeader();
        text.append(reportHeader);
        Preferences.main().getAllSettings().forEach((key, setting) -> {
            if ("file-open.history".equals(key) || "download.overpass.query".equals(key) || "download.overpass.queries".equals(key) || key.contains("username") || key.contains("password") || key.contains("access-token")) {
                return;
            }
            text.append(ShowStatusReportAction.paramCleanup(key)).append('=').append(ShowStatusReportAction.paramCleanup(setting.getValue().toString())).append('\n');
        });
        DebugTextDisplay ta = new DebugTextDisplay(text.toString());
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Status Report", new Object[0]), I18n.tr("Copy to clipboard and close", new Object[0]), I18n.tr("Report bug", new Object[0]), I18n.tr("Close", new Object[0]));
        ed.setButtonIcons("copy", "bug", "cancel");
        ed.setContent(ta, false);
        ed.setMinimumSize(new Dimension(380, 200));
        ed.setPreferredSize(new Dimension(700, MainApplication.getMainFrame().getHeight() - 50));
        switch (ed.showDialog().getValue()) {
            case 1: {
                ta.copyToClipboard();
                break;
            }
            case 2: {
                BugReportSender.reportBug(reportHeader);
                break;
            }
        }
        GuiHelper.destroyComponents(ed, false);
    }
}

