/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class PropertiesCellRenderer
extends DefaultTableCellRenderer {
    private static final CachingProperty<Color> SELECTED_FG = new NamedColorProperty(I18n.marktr("Discardable key: selection Foreground"), Color.GRAY).cached();
    private static final CachingProperty<Color> SELECTED_BG;
    private static final CachingProperty<Color> NORMAL_FG;
    private static final CachingProperty<Color> NORMAL_BG;
    private static final CachingProperty<Boolean> DISCARDABLE;
    private final Collection<TableCellRenderer> customRenderer = new CopyOnWriteArrayList<TableCellRenderer>();

    private static void setColors(Component c, String key, boolean isSelected) {
        if (AbstractPrimitive.getDiscardableKeys().contains(key)) {
            c.setForeground((isSelected ? SELECTED_FG : NORMAL_FG).get());
            c.setBackground((isSelected ? SELECTED_BG : NORMAL_BG).get());
        } else {
            c.setForeground(UIManager.getColor("Table." + (isSelected ? "selectionF" : "f") + "oreground"));
            c.setBackground(UIManager.getColor("Table." + (isSelected ? "selectionB" : "b") + "ackground"));
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        for (TableCellRenderer renderer : this.customRenderer) {
            Component component = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component == null) continue;
            return component;
        }
        if (value == null) {
            return this;
        }
        Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        if (c instanceof JLabel) {
            Pair<String, Boolean> label;
            String str = null;
            if (value instanceof String) {
                str = (String)value;
            } else if (value instanceof Map) {
                Map v = (Map)value;
                if (v.size() != 1) {
                    Integer otherCount;
                    Integer blankCount;
                    if (v.get("") == null) {
                        blankCount = 0;
                        otherCount = v.size();
                    } else {
                        blankCount = (Integer)v.get("");
                        otherCount = v.size() - 1;
                    }
                    StringBuilder sb = new StringBuilder("<");
                    if (otherCount == 1) {
                        v.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), "")).findAny().ifPresent(entry -> sb.append(I18n.tr("{0} ''{1}''", entry.getValue().toString(), entry.getKey())));
                    } else {
                        sb.append(I18n.trn("{0} different", "{0} different", otherCount.intValue(), otherCount));
                    }
                    if (blankCount > 0) {
                        sb.append(I18n.trn(", {0} unset", ", {0} unset", blankCount.intValue(), blankCount));
                    }
                    sb.append('>');
                    str = sb.toString();
                    c.setFont(c.getFont().deriveFont(2));
                } else {
                    str = (String)v.entrySet().iterator().next().getKey();
                }
            }
            boolean knownNameKey = false;
            if (column == 0 && str != null && (label = I18n.getLocalizedLanguageName(str)) != null && (knownNameKey = ((Boolean)label.b).booleanValue())) {
                str = "<html><body>" + str + " <i>&lt;" + (String)label.a + "&gt;</i></body></html>";
            }
            ((JLabel)c).putClientProperty("html.disable", knownNameKey ? null : Boolean.TRUE);
            ((JLabel)c).setText(str);
            if (DISCARDABLE.get().booleanValue()) {
                Object value0;
                String key = null;
                if (column == 0) {
                    key = str;
                } else if (column == 1 && (value0 = table.getModel().getValueAt(row, 0)) instanceof String) {
                    key = (String)value0;
                }
                PropertiesCellRenderer.setColors(c, key, isSelected);
            }
        }
        return c;
    }

    public void addCustomRenderer(TableCellRenderer renderer) {
        this.customRenderer.add(renderer);
    }

    public void removeCustomRenderer(TableCellRenderer renderer) {
        this.customRenderer.remove(renderer);
    }

    static {
        NORMAL_FG = new NamedColorProperty(I18n.marktr("Discardable key: foreground"), Color.GRAY).cached();
        DISCARDABLE = new BooleanProperty("display.discardable-keys", false).cached();
        SELECTED_BG = new NamedColorProperty(I18n.marktr("Discardable key: selection Background"), Optional.ofNullable(UIManager.getColor("Table.selectionBackground")).orElse(Color.BLUE)).cached();
        NORMAL_BG = new NamedColorProperty(I18n.marktr("Discardable key: background"), Optional.ofNullable(UIManager.getColor("Table.background")).orElse(Color.WHITE)).cached();
    }
}

