# SLA, chapter 2
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been autogenerated with GAP. It contains examples
# extracted from the documentation. Each example is preceded by the
# comment which points to the location of its source.
#
gap> START_TEST( "sla02.tst");

# doc/manual.xml:93-98
gap> R:= RootSystem("F",4);;
gap> ExtendedCartanMatrix(R);
rec( ECM := [ [ 2, -1, 0, 0, 0 ], [ -1, 2, -1, 0, 0 ], [ 0, -1, 2, -2, 0 ], 
      [ 0, 0, -1, 2, -1 ], [ 0, 0, 0, -1, 2 ] ], labels := [ 1, 2, 3, 4, 2 ] )

# doc/manual.xml:117-123
gap> C:= [[2,0,-3,0],[0,2,0,-1],[-1,0,2,0],[0,-1,0,2]];
[ [ 2, 0, -3, 0 ], [ 0, 2, 0, -1 ], [ -1, 0, 2, 0 ], [ 0, -1, 0, 2 ] ]
gap> CartanType(C);
rec( enumeration := [ [ 3, 1 ], [ 2, 4 ] ], 
  types := [ [ "G", 2 ], [ "A", 2 ] ] )

# doc/manual.xml:152-161
gap> R:= RootSystem("A",3);;
gap> WeylTransversal( R, [2,6] );
[ [  ], [ 1 ], [ 3 ], [ 1, 2 ], [ 1, 3 ], [ 3, 2 ] ]
gap> R:= RootSystem("E",8);;
gap> p:= PositiveRootsNF(R);;
gap> a:= WeylTransversal( R, [p[1],p[3],p[4],p[5],p[6],p[7],p[8],-p[120]] );;
gap> Length(a);
1920

# doc/manual.xml:180-188
gap> R:= RootSystem( SimpleLieAlgebra("E",6,Rationals) );;
gap> SizeOfWeylGroup(R);                
51840
gap> SizeOfWeylGroup( [["E",6]] );
51840
gap> SizeOfWeylGroup( "E", 6 );   
51840

# doc/manual.xml:223-237
gap> L:= SimpleLieAlgebra("G",2,Rationals);;
gap> V:= HighestWeightModule( L, [2,0] );
<27-dimensional left-module over <Lie algebra of dimension 14 over Rationals>>
gap> B:=AdmissibleLattice(V);;
gap> x:= L.1;
v.1
gap> mx:= MatrixOfAction( B, x );;
gap> IsZero(mx^4); IsZero(mx^5);
false
true
gap> exp:=Sum( List( [0..4], i -> mx^i/Factorial(i) ) );;
gap> ForAll( Flat(exp), IsInt );
true

# doc/manual.xml:251-263
gap> L:= SimpleLieAlgebra("G",2,Rationals);;
gap> V:= HighestWeightModule( L, [1,0] );;
gap> W:= TensorProductOfAlgebraModules( V, V );
<49-dimensional left-module over <Lie algebra of dimension 14 over Rationals>>
gap> DirectSumDecomposition( W );
[ <left-module over <Lie algebra of dimension 14 over Rationals>>, 
  <left-module over <Lie algebra of dimension 14 over Rationals>>, 
  <left-module over <Lie algebra of dimension 14 over Rationals>>, 
  <left-module over <Lie algebra of dimension 14 over Rationals>> ]
gap> List( last, Dimension );
[ 27, 7, 14, 1 ]

# doc/manual.xml:297-303
gap> L:= SimpleLieAlgebra("G",2,Rationals);;
gap> L:= SimpleLieAlgebra("G",2,Rationals);;
gap> CharacteristicsOfStrata( L, [0,1] );
[ [ v.13+(2)*v.14, (2)*v.13+(3)*v.14, (2)*v.13+(4)*v.14, (6)*v.13+(10)*v.14 ],
  [ 6, 8, 10, 12 ] ]
gap> STOP_TEST("sla02.tst", 1 );
