#ifndef _EFL_CUBIC_BEZIER_INTERPOLATOR_EO_H_
#define _EFL_CUBIC_BEZIER_INTERPOLATOR_EO_H_

#ifndef _EFL_CUBIC_BEZIER_INTERPOLATOR_EO_CLASS_TYPE
#define _EFL_CUBIC_BEZIER_INTERPOLATOR_EO_CLASS_TYPE

typedef Eo Efl_Cubic_Bezier_Interpolator;

#endif

#ifndef _EFL_CUBIC_BEZIER_INTERPOLATOR_EO_TYPES
#define _EFL_CUBIC_BEZIER_INTERPOLATOR_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl cubic_bezier interpolator class
 *
 * @ingroup Efl_Cubic_Bezier_Interpolator
 */
#define EFL_CUBIC_BEZIER_INTERPOLATOR_CLASS efl_cubic_bezier_interpolator_class_get()

EWAPI const Efl_Class *efl_cubic_bezier_interpolator_class_get(void);

/**
 * @brief Factors property
 *
 * @param[in] obj The object.
 * @param[in] factor1 First factor of the interpolation function.
 * @param[in] factor2 Second factor of the interpolation function.
 * @param[in] factor3 Third factor of the interpolation function.
 * @param[in] factor4 Fourth factor of the interpolation function.
 *
 * @ingroup Efl_Cubic_Bezier_Interpolator
 */
EOAPI void efl_cubic_bezier_interpolator_factors_set(Eo *obj, double factor1, double factor2, double factor3, double factor4);

/**
 * @brief Factors property
 *
 * @param[in] obj The object.
 * @param[out] factor1 First factor of the interpolation function.
 * @param[out] factor2 Second factor of the interpolation function.
 * @param[out] factor3 Third factor of the interpolation function.
 * @param[out] factor4 Fourth factor of the interpolation function.
 *
 * @ingroup Efl_Cubic_Bezier_Interpolator
 */
EOAPI void efl_cubic_bezier_interpolator_factors_get(const Eo *obj, double *factor1, double *factor2, double *factor3, double *factor4);
#endif /* EFL_BETA_API_SUPPORT */

#endif
