#ifndef _EFL_CANVAS_GESTURE_RECOGNIZER_DOUBLE_TAP_EO_H_
#define _EFL_CANVAS_GESTURE_RECOGNIZER_DOUBLE_TAP_EO_H_

#ifndef _EFL_CANVAS_GESTURE_RECOGNIZER_DOUBLE_TAP_EO_CLASS_TYPE
#define _EFL_CANVAS_GESTURE_RECOGNIZER_DOUBLE_TAP_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Gesture_Recognizer_Double_Tap;

#endif

#ifndef _EFL_CANVAS_GESTURE_RECOGNIZER_DOUBLE_TAP_EO_TYPES
#define _EFL_CANVAS_GESTURE_RECOGNIZER_DOUBLE_TAP_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** This is the recognizer for Double-Tap gestures. See
 * @ref Efl_Canvas_Gesture_Double_Tap and @ref Efl_Canvas_Gesture_Recognizer.
 * For internal use only.
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer_Double_Tap
 */
#define EFL_CANVAS_GESTURE_RECOGNIZER_DOUBLE_TAP_CLASS efl_canvas_gesture_recognizer_double_tap_class_get()

EWAPI const Efl_Class *efl_canvas_gesture_recognizer_double_tap_class_get(void);

/**
 * @brief Maximum time between taps to be recognized as a double tap.
 *
 * @param[in] obj The object.
 * @param[in] time Time in seconds.
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer_Double_Tap
 */
EOAPI void efl_gesture_recognizer_double_tap_timeout_set(Eo *obj, double time);

/**
 * @brief Maximum time between taps to be recognized as a double tap.
 *
 * @param[in] obj The object.
 *
 * @return Time in seconds.
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer_Double_Tap
 */
EOAPI double efl_gesture_recognizer_double_tap_timeout_get(const Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
