/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dom;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLCryptoContext;
import org.w3c.dom.Element;

public class DOMCryptoContext
implements XMLCryptoContext {
    private HashMap nsMap = new HashMap();
    private HashMap idMap = new HashMap();
    private HashMap objMap = new HashMap();
    private String baseURI;
    private KeySelector ks;
    private URIDereferencer dereferencer;
    private HashMap propMap = new HashMap();
    private String defaultPrefix;

    protected DOMCryptoContext() {
    }

    @Override
    public String getNamespacePrefix(String namespaceURI, String defaultPrefix) {
        if (namespaceURI == null) {
            throw new NullPointerException("namespaceURI cannot be null");
        }
        String prefix = (String)this.nsMap.get(namespaceURI);
        return prefix != null ? prefix : defaultPrefix;
    }

    @Override
    public String putNamespacePrefix(String namespaceURI, String prefix) {
        if (namespaceURI == null) {
            throw new NullPointerException("namespaceURI is null");
        }
        return this.nsMap.put(namespaceURI, prefix);
    }

    @Override
    public String getDefaultNamespacePrefix() {
        return this.defaultPrefix;
    }

    @Override
    public void setDefaultNamespacePrefix(String defaultPrefix) {
        this.defaultPrefix = defaultPrefix;
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public void setBaseURI(String baseURI) {
        if (baseURI != null) {
            URI.create(baseURI);
        }
        this.baseURI = baseURI;
    }

    @Override
    public URIDereferencer getURIDereferencer() {
        return this.dereferencer;
    }

    @Override
    public void setURIDereferencer(URIDereferencer dereferencer) {
        this.dereferencer = dereferencer;
    }

    @Override
    public Object getProperty(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.propMap.get(name);
    }

    @Override
    public Object setProperty(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.propMap.put(name, value);
    }

    @Override
    public KeySelector getKeySelector() {
        return this.ks;
    }

    @Override
    public void setKeySelector(KeySelector ks) {
        this.ks = ks;
    }

    public Element getElementById(String idValue) {
        if (idValue == null) {
            throw new NullPointerException("idValue is null");
        }
        return (Element)this.idMap.get(idValue);
    }

    public void setIdAttributeNS(Element element, String namespaceURI, String localName) {
        if (element == null) {
            throw new NullPointerException("element is null");
        }
        if (localName == null) {
            throw new NullPointerException("localName is null");
        }
        String idValue = element.getAttributeNS(namespaceURI, localName);
        if (idValue == null || idValue.length() == 0) {
            throw new IllegalArgumentException(localName + " is not an " + "attribute");
        }
        this.idMap.put(idValue, element);
    }

    public Iterator iterator() {
        return Collections.unmodifiableMap(this.idMap).entrySet().iterator();
    }

    @Override
    public Object get(Object key) {
        return this.objMap.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.objMap.put(key, value);
    }
}

