/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;
import sun.security.x509.X509AttributeName;

public class CRLExtensions {
    private Map<String, Extension> map = Collections.synchronizedMap(new TreeMap());
    private boolean unsupportedCritExt = false;
    private static final Class[] PARAMS = new Class[]{Boolean.class, Object.class};

    public CRLExtensions() {
    }

    public CRLExtensions(DerInputStream in) throws CRLException {
        this.init(in);
    }

    private void init(DerInputStream derStrm) throws CRLException {
        try {
            DerInputStream str = derStrm;
            byte nextByte = (byte)derStrm.peekByte();
            if ((nextByte & 0xC0) == 128 && (nextByte & 0x1F) == 0) {
                DerValue val = str.getDerValue();
                str = val.data;
            }
            DerValue[] exts = str.getSequence(5);
            for (int i = 0; i < exts.length; ++i) {
                Extension ext = new Extension(exts[i]);
                this.parseExtension(ext);
            }
        }
        catch (IOException e) {
            throw new CRLException("Parsing error: " + e.toString());
        }
    }

    private void parseExtension(Extension ext) throws CRLException {
        try {
            Class<?> extClass = OIDMap.getClass(ext.getExtensionId());
            if (extClass == null) {
                if (ext.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(ext.getExtensionId().toString(), ext) != null) {
                    throw new CRLException("Duplicate extensions not allowed");
                }
                return;
            }
            Constructor<?> cons = extClass.getConstructor(PARAMS);
            Object[] passed = new Object[]{ext.isCritical(), ext.getExtensionValue()};
            CertAttrSet crlExt = (CertAttrSet)cons.newInstance(passed);
            if (this.map.put(crlExt.getName(), (Extension)((Object)crlExt)) != null) {
                throw new CRLException("Duplicate extensions not allowed");
            }
        }
        catch (InvocationTargetException invk) {
            throw new CRLException(invk.getTargetException().getMessage());
        }
        catch (Exception e) {
            throw new CRLException(e.toString());
        }
    }

    public void encode(OutputStream out, boolean isExplicit) throws CRLException {
        try {
            DerOutputStream extOut = new DerOutputStream();
            Collection<Extension> allExts = this.map.values();
            Object[] objs = allExts.toArray();
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] instanceof CertAttrSet) {
                    ((CertAttrSet)objs[i]).encode(extOut);
                    continue;
                }
                if (objs[i] instanceof Extension) {
                    ((Extension)objs[i]).encode(extOut);
                    continue;
                }
                throw new CRLException("Illegal extension object");
            }
            DerOutputStream seq = new DerOutputStream();
            seq.write((byte)48, extOut);
            DerOutputStream tmp = new DerOutputStream();
            if (isExplicit) {
                tmp.write(DerValue.createTag((byte)-128, true, (byte)0), seq);
            } else {
                tmp = seq;
            }
            out.write(tmp.toByteArray());
        }
        catch (IOException e) {
            throw new CRLException("Encoding error: " + e.toString());
        }
        catch (CertificateException e) {
            throw new CRLException("Encoding error: " + e.toString());
        }
    }

    public Extension get(String alias) {
        String name;
        X509AttributeName attr = new X509AttributeName(alias);
        String id = attr.getPrefix();
        if (id.equalsIgnoreCase("x509")) {
            int index = alias.lastIndexOf(".");
            name = alias.substring(index + 1);
        } else {
            name = alias;
        }
        return this.map.get(name);
    }

    public void set(String alias, Object obj) {
        this.map.put(alias, (Extension)obj);
    }

    public void delete(String alias) {
        this.map.remove(alias);
    }

    public Enumeration<Extension> getElements() {
        return Collections.enumeration(this.map.values());
    }

    public Collection<Extension> getAllExtensions() {
        return this.map.values();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCritExt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CRLExtensions)) {
            return false;
        }
        Collection<Extension> otherC = ((CRLExtensions)other).getAllExtensions();
        Object[] objs = otherC.toArray();
        int len = objs.length;
        if (len != this.map.size()) {
            return false;
        }
        String key = null;
        for (int i = 0; i < len; ++i) {
            Extension thisExt;
            if (objs[i] instanceof CertAttrSet) {
                key = ((CertAttrSet)objs[i]).getName();
            }
            Extension otherExt = (Extension)objs[i];
            if (key == null) {
                key = otherExt.getExtensionId().toString();
            }
            if ((thisExt = this.map.get(key)) == null) {
                return false;
            }
            if (thisExt.equals(otherExt)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

