/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongHashMap;
import org.netbeans.lib.profiler.heap.LongIterator;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.LongSet;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;

class DominatorTree {
    private static final int BUFFER_SIZE = 8192;
    private static final int ADDITIONAL_IDS_THRESHOLD = 30;
    private static final int ADDITIONAL_IDS_THRESHOLD_DIRTYSET_SAME_SIZE = 5;
    private HprofHeap heap;
    private LongBuffer multipleParents;
    private LongBuffer revertedMultipleParents;
    private LongBuffer currentMultipleParents;
    private LongHashMap map;
    private LongSet dirtySet;
    private int dirtySetSameSize;
    private Map canContainItself;
    private Map nearestGCRootCache = new NearestGCRootCache(400000);

    DominatorTree(HprofHeap hprofHeap, LongBuffer longBuffer) {
        this.heap = hprofHeap;
        this.currentMultipleParents = this.multipleParents = longBuffer;
        this.map = new LongHashMap(longBuffer.getSize());
        this.dirtySet = new LongSet();
        try {
            this.revertedMultipleParents = longBuffer.revertBuffer();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getLocalizedMessage(), iOException);
        }
    }

    synchronized void computeDominators() {
        boolean bl = true;
        try {
            boolean bl2;
            do {
                this.currentMultipleParents.rewind();
                bl2 = !bl;
                bl = this.computeOneLevel(bl2);
                this.switchParents();
            } while (bl || !bl2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.deleteBuffers();
        this.dirtySet = new LongSet();
    }

    private boolean computeOneLevel(boolean bl) throws IOException {
        boolean bl2 = false;
        LongSet longSet = new LongSet(this.map.size() / 10);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n = 0;
        while (true) {
            long l;
            long l2;
            if ((l2 = this.readLong()) == 0L) {
                if (n >= arrayList.size()) {
                    if (n <= 0) break;
                    break;
                }
                l2 = (Long)arrayList.get(n++);
            }
            if ((l = this.map.get(l2)) != -1L && (l <= 0L || !bl && !this.dirtySet.contains(l) && !this.dirtySet.contains(l2))) continue;
            LongMap.Entry entry = this.heap.idToOffsetMap.get(l2);
            LongIterator longIterator = entry.getReferences();
            long l3 = longIterator.next();
            boolean bl3 = false;
            while (longIterator.hasNext() && l3 != 0L) {
                long l4 = longIterator.next();
                l3 = this.intersect(l3, l4);
            }
            if (l == -1L) {
                this.map.put(l2, l3);
                if (l3 != 0L) {
                    longSet.add(l3);
                }
                bl2 = true;
                continue;
            }
            if (l == l3) continue;
            longSet.add(l);
            if (l3 != 0L) {
                longSet.add(l3);
            }
            this.map.put(l2, l3);
            if (this.dirtySet.size() < 30 || this.dirtySetSameSize >= 5) {
                this.updateAdditionalIds(l2, arrayList);
            }
            bl2 = true;
        }
        this.dirtySetSameSize = this.dirtySet.size() != longSet.size() ? 0 : ++this.dirtySetSameSize;
        this.dirtySet = longSet;
        return bl2;
    }

    private void updateAdditionalIds(long l, List<Long> list) {
        Instance instance = this.heap.getInstanceByID(l);
        if (instance != null) {
            for (Object e : instance.getFieldValues()) {
                Instance instance2;
                if (!(e instanceof ObjectFieldValue) || (instance2 = ((ObjectFieldValue)e).getInstance()) == null) continue;
                long l2 = instance2.getInstanceId();
                Long l3 = new Long(l2);
                long l4 = this.map.get(l2);
                if (l4 <= 0L) continue;
                list.add(l3);
            }
        }
    }

    private void deleteBuffers() {
        this.multipleParents.delete();
        this.revertedMultipleParents.delete();
    }

    private long readLong() throws IOException {
        return this.currentMultipleParents.readLong();
    }

    long getIdomId(long l, LongMap.Entry entry) {
        long l2 = this.map.get(l);
        if (l2 != -1L) {
            return l2;
        }
        if (entry == null) {
            entry = this.heap.idToOffsetMap.get(l);
        }
        return entry.getNearestGCRootPointer();
    }

    boolean hasInstanceInChain(int n, Instance instance) {
        Object object;
        if (n == 35) {
            return false;
        }
        ClassDump classDump = (ClassDump)instance.getJavaClass();
        if (this.canContainItself == null) {
            this.canContainItself = new HashMap(this.heap.getAllClasses().size() / 2);
        }
        if (n == 33) {
            object = (Boolean)this.canContainItself.get(classDump);
            if (object == null) {
                object = classDump.canContainItself();
                this.canContainItself.put(classDump, object);
            }
            if (!((Boolean)object).booleanValue()) {
                return false;
            }
        }
        long l = instance.getInstanceId();
        long l2 = this.getIdomId(l);
        while (l2 != 0L) {
            object = this.heap.getInstanceByID(l2);
            JavaClass javaClass = object.getJavaClass();
            if (classDump.equals(javaClass)) {
                return true;
            }
            l2 = this.getIdomId(l2);
        }
        return false;
    }

    private Long getNearestGCRootPointer(Long l) {
        Long l2 = (Long)this.nearestGCRootCache.get(l);
        if (l2 != null) {
            return l2;
        }
        LongMap.Entry entry = this.heap.idToOffsetMap.get(l);
        Long l3 = entry.getNearestGCRootPointer();
        this.nearestGCRootCache.put(l, l3);
        return l3;
    }

    private long getIdomId(long l) {
        long l2 = this.map.get(l);
        if (l2 != -1L) {
            return l2;
        }
        return this.getNearestGCRootPointer(l);
    }

    private long intersect(long l, long l2) {
        if (l == l2) {
            return l;
        }
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        LongSet longSet = new LongSet(200);
        LongSet longSet2 = new LongSet(200);
        long l3 = l;
        long l4 = l2;
        longSet.add(l3);
        longSet2.add(l4);
        while (l4 != 0L || l3 != 0L) {
            if (l3 != 0L && (l3 = this.getIdomId(l3)) != 0L) {
                if (longSet2.contains(l3)) {
                    return l3;
                }
                longSet.add(l3);
            }
            if (l4 == 0L || (l4 = this.getIdomId(l4)) == 0L) continue;
            if (longSet.contains(l4)) {
                return l4;
            }
            longSet2.add(l4);
        }
        return 0L;
    }

    private void switchParents() {
        this.currentMultipleParents = this.currentMultipleParents == this.revertedMultipleParents ? this.multipleParents : this.revertedMultipleParents;
    }

    private void printObjs(List<Long> list, List<Long> list2, List<Long> list3, List<Boolean> list4, List<Long> list5) {
        if (list.size() > 20) {
            return;
        }
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        for (int i = 0; i < list.size(); ++i) {
            Number number = list.get(i);
            Long l = list2.get(i);
            Long l2 = list3.get(i);
            Long l3 = list5.get(i);
            Boolean bl = list4.get(i);
            Instance instance = this.heap.getInstanceByID((Long)number);
            int n = instance.getInstanceNumber();
            String string = "Index: " + l3 + (bl != false ? " New " : " Old ") + this.printInstance((Long)number);
            string = string + " OldDom " + this.printInstance(l);
            string = string + " NewDom: " + this.printInstance(l2);
            treeMap.put(n, string);
        }
        for (Number number : treeMap.keySet()) {
            System.out.println((String)treeMap.get(number));
        }
    }

    String printInstance(Long l) {
        if (l == null || l == 0L) {
            return "null";
        }
        Instance instance = this.heap.getInstanceByID(l);
        return instance.getJavaClass().getName() + "#" + instance.getInstanceNumber();
    }

    void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        this.map.writeToStream(dataOutputStream);
    }

    DominatorTree(HprofHeap hprofHeap, DataInputStream dataInputStream) throws IOException {
        this.heap = hprofHeap;
        this.map = new LongHashMap(dataInputStream);
    }

    private static final class NearestGCRootCache
    extends LinkedHashMap {
        private final int maxSize;

        private NearestGCRootCache(int n) {
            super(n, 0.75f, true);
            this.maxSize = n;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > this.maxSize;
        }
    }
}

