/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common;

import java.util.ResourceBundle;
import org.netbeans.lib.profiler.common.ProfilingSettings;

public class ProfilingSettingsPresets {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.common.Bundle");
    private static final String MONITOR_PRESET_NAME = bundle.getString("ProfilingSettingsPresets_MonitorPresetName");
    private static final String CPU_PRESET_NAME = bundle.getString("ProfilingSettingsPresets_CpuPresetName");
    private static final String MEMORY_PRESET_NAME = bundle.getString("ProfilingSettingsPresets_MemoryPresetName");

    public static ProfilingSettings createCPUPreset() {
        return ProfilingSettingsPresets.createCPUPreset(64);
    }

    public static ProfilingSettings createCPUPreset(int n) {
        return new CPUPreset(n);
    }

    public static ProfilingSettings createMemoryPreset() {
        return ProfilingSettingsPresets.createMemoryPreset(128);
    }

    public static ProfilingSettings createMemoryPreset(int n) {
        return new MemoryPreset(n);
    }

    public static ProfilingSettings createMonitorPreset() {
        return new MonitorPreset();
    }

    private static final class MonitorPreset
    extends ProfilingSettings {
        public MonitorPreset() {
            this.setIsPreset(true);
            this.setProfilingType(1);
            this.setSettingsName(MONITOR_PRESET_NAME);
        }
    }

    private static final class MemoryPreset
    extends ProfilingSettings {
        public MemoryPreset(int n) {
            this.setIsPreset(true);
            this.setProfilingType(n);
            this.setSettingsName(MEMORY_PRESET_NAME);
        }
    }

    private static final class CPUPreset
    extends ProfilingSettings {
        public CPUPreset(int n) {
            this.setIsPreset(true);
            this.setProfilingType(n);
            this.setSettingsName(CPU_PRESET_NAME);
            this.setCPUProfilingType(n == 64 ? 2 : 0);
            this.setInstrumentGetterSetterMethods(false);
            this.setInstrumentEmptyMethods(false);
            this.setInstrumentMethodInvoke(true);
            this.setExcludeWaitTime(true);
            if (n == 8) {
                this.setInstrScheme(3);
                this.setInstrumentSpawnedThreads(false);
            } else if (n == 16) {
                this.setInstrScheme(1);
                this.setInstrumentSpawnedThreads(false);
            } else if (n == 256) {
                this.setInstrScheme(1);
                this.setInstrumentSpawnedThreads(false);
            } else if (n == 64) {
                this.setSamplingFrequency(10);
                this.setThreadCPUTimerOn(true);
            }
        }
    }
}

