﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Xml
{
  class XmlNode;
} // namespace Xml
} // namespace Utils
namespace EC2
{
namespace Model
{

  /**
   * <p>Describes an IPv6 CIDR block association.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Ipv6CidrAssociation">AWS
   * API Reference</a></p>
   */
  class AWS_EC2_API Ipv6CidrAssociation
  {
  public:
    Ipv6CidrAssociation();
    Ipv6CidrAssociation(const Aws::Utils::Xml::XmlNode& xmlNode);
    Ipv6CidrAssociation& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

    void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
    void OutputToStream(Aws::OStream& oStream, const char* location) const;


    /**
     * <p>The IPv6 CIDR block.</p>
     */
    inline const Aws::String& GetIpv6Cidr() const{ return m_ipv6Cidr; }

    /**
     * <p>The IPv6 CIDR block.</p>
     */
    inline bool Ipv6CidrHasBeenSet() const { return m_ipv6CidrHasBeenSet; }

    /**
     * <p>The IPv6 CIDR block.</p>
     */
    inline void SetIpv6Cidr(const Aws::String& value) { m_ipv6CidrHasBeenSet = true; m_ipv6Cidr = value; }

    /**
     * <p>The IPv6 CIDR block.</p>
     */
    inline void SetIpv6Cidr(Aws::String&& value) { m_ipv6CidrHasBeenSet = true; m_ipv6Cidr = std::move(value); }

    /**
     * <p>The IPv6 CIDR block.</p>
     */
    inline void SetIpv6Cidr(const char* value) { m_ipv6CidrHasBeenSet = true; m_ipv6Cidr.assign(value); }

    /**
     * <p>The IPv6 CIDR block.</p>
     */
    inline Ipv6CidrAssociation& WithIpv6Cidr(const Aws::String& value) { SetIpv6Cidr(value); return *this;}

    /**
     * <p>The IPv6 CIDR block.</p>
     */
    inline Ipv6CidrAssociation& WithIpv6Cidr(Aws::String&& value) { SetIpv6Cidr(std::move(value)); return *this;}

    /**
     * <p>The IPv6 CIDR block.</p>
     */
    inline Ipv6CidrAssociation& WithIpv6Cidr(const char* value) { SetIpv6Cidr(value); return *this;}


    /**
     * <p>The resource that's associated with the IPv6 CIDR block.</p>
     */
    inline const Aws::String& GetAssociatedResource() const{ return m_associatedResource; }

    /**
     * <p>The resource that's associated with the IPv6 CIDR block.</p>
     */
    inline bool AssociatedResourceHasBeenSet() const { return m_associatedResourceHasBeenSet; }

    /**
     * <p>The resource that's associated with the IPv6 CIDR block.</p>
     */
    inline void SetAssociatedResource(const Aws::String& value) { m_associatedResourceHasBeenSet = true; m_associatedResource = value; }

    /**
     * <p>The resource that's associated with the IPv6 CIDR block.</p>
     */
    inline void SetAssociatedResource(Aws::String&& value) { m_associatedResourceHasBeenSet = true; m_associatedResource = std::move(value); }

    /**
     * <p>The resource that's associated with the IPv6 CIDR block.</p>
     */
    inline void SetAssociatedResource(const char* value) { m_associatedResourceHasBeenSet = true; m_associatedResource.assign(value); }

    /**
     * <p>The resource that's associated with the IPv6 CIDR block.</p>
     */
    inline Ipv6CidrAssociation& WithAssociatedResource(const Aws::String& value) { SetAssociatedResource(value); return *this;}

    /**
     * <p>The resource that's associated with the IPv6 CIDR block.</p>
     */
    inline Ipv6CidrAssociation& WithAssociatedResource(Aws::String&& value) { SetAssociatedResource(std::move(value)); return *this;}

    /**
     * <p>The resource that's associated with the IPv6 CIDR block.</p>
     */
    inline Ipv6CidrAssociation& WithAssociatedResource(const char* value) { SetAssociatedResource(value); return *this;}

  private:

    Aws::String m_ipv6Cidr;
    bool m_ipv6CidrHasBeenSet;

    Aws::String m_associatedResource;
    bool m_associatedResourceHasBeenSet;
  };

} // namespace Model
} // namespace EC2
} // namespace Aws
