﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/mediapackage/MediaPackage_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace MediaPackage
{
namespace Model
{

  /**
   * CDN Authorization credentials<p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/Authorization">AWS
   * API Reference</a></p>
   */
  class AWS_MEDIAPACKAGE_API Authorization
  {
  public:
    Authorization();
    Authorization(Aws::Utils::Json::JsonView jsonValue);
    Authorization& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * The Amazon Resource Name (ARN) for the secret in Secrets Manager that your
     * Content Distribution Network (CDN) uses for authorization to access your
     * endpoint.

     */
    inline const Aws::String& GetCdnIdentifierSecret() const{ return m_cdnIdentifierSecret; }

    /**
     * The Amazon Resource Name (ARN) for the secret in Secrets Manager that your
     * Content Distribution Network (CDN) uses for authorization to access your
     * endpoint.

     */
    inline bool CdnIdentifierSecretHasBeenSet() const { return m_cdnIdentifierSecretHasBeenSet; }

    /**
     * The Amazon Resource Name (ARN) for the secret in Secrets Manager that your
     * Content Distribution Network (CDN) uses for authorization to access your
     * endpoint.

     */
    inline void SetCdnIdentifierSecret(const Aws::String& value) { m_cdnIdentifierSecretHasBeenSet = true; m_cdnIdentifierSecret = value; }

    /**
     * The Amazon Resource Name (ARN) for the secret in Secrets Manager that your
     * Content Distribution Network (CDN) uses for authorization to access your
     * endpoint.

     */
    inline void SetCdnIdentifierSecret(Aws::String&& value) { m_cdnIdentifierSecretHasBeenSet = true; m_cdnIdentifierSecret = std::move(value); }

    /**
     * The Amazon Resource Name (ARN) for the secret in Secrets Manager that your
     * Content Distribution Network (CDN) uses for authorization to access your
     * endpoint.

     */
    inline void SetCdnIdentifierSecret(const char* value) { m_cdnIdentifierSecretHasBeenSet = true; m_cdnIdentifierSecret.assign(value); }

    /**
     * The Amazon Resource Name (ARN) for the secret in Secrets Manager that your
     * Content Distribution Network (CDN) uses for authorization to access your
     * endpoint.

     */
    inline Authorization& WithCdnIdentifierSecret(const Aws::String& value) { SetCdnIdentifierSecret(value); return *this;}

    /**
     * The Amazon Resource Name (ARN) for the secret in Secrets Manager that your
     * Content Distribution Network (CDN) uses for authorization to access your
     * endpoint.

     */
    inline Authorization& WithCdnIdentifierSecret(Aws::String&& value) { SetCdnIdentifierSecret(std::move(value)); return *this;}

    /**
     * The Amazon Resource Name (ARN) for the secret in Secrets Manager that your
     * Content Distribution Network (CDN) uses for authorization to access your
     * endpoint.

     */
    inline Authorization& WithCdnIdentifierSecret(const char* value) { SetCdnIdentifierSecret(value); return *this;}


    /**
     * The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to
     * communicate with AWS Secrets Manager.

     */
    inline const Aws::String& GetSecretsRoleArn() const{ return m_secretsRoleArn; }

    /**
     * The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to
     * communicate with AWS Secrets Manager.

     */
    inline bool SecretsRoleArnHasBeenSet() const { return m_secretsRoleArnHasBeenSet; }

    /**
     * The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to
     * communicate with AWS Secrets Manager.

     */
    inline void SetSecretsRoleArn(const Aws::String& value) { m_secretsRoleArnHasBeenSet = true; m_secretsRoleArn = value; }

    /**
     * The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to
     * communicate with AWS Secrets Manager.

     */
    inline void SetSecretsRoleArn(Aws::String&& value) { m_secretsRoleArnHasBeenSet = true; m_secretsRoleArn = std::move(value); }

    /**
     * The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to
     * communicate with AWS Secrets Manager.

     */
    inline void SetSecretsRoleArn(const char* value) { m_secretsRoleArnHasBeenSet = true; m_secretsRoleArn.assign(value); }

    /**
     * The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to
     * communicate with AWS Secrets Manager.

     */
    inline Authorization& WithSecretsRoleArn(const Aws::String& value) { SetSecretsRoleArn(value); return *this;}

    /**
     * The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to
     * communicate with AWS Secrets Manager.

     */
    inline Authorization& WithSecretsRoleArn(Aws::String&& value) { SetSecretsRoleArn(std::move(value)); return *this;}

    /**
     * The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to
     * communicate with AWS Secrets Manager.

     */
    inline Authorization& WithSecretsRoleArn(const char* value) { SetSecretsRoleArn(value); return *this;}

  private:

    Aws::String m_cdnIdentifierSecret;
    bool m_cdnIdentifierSecretHasBeenSet;

    Aws::String m_secretsRoleArn;
    bool m_secretsRoleArnHasBeenSet;
  };

} // namespace Model
} // namespace MediaPackage
} // namespace Aws
