﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace QuickSight
{
namespace Model
{

  /**
   * <p>A transform operation that filters rows based on a condition.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/FilterOperation">AWS
   * API Reference</a></p>
   */
  class AWS_QUICKSIGHT_API FilterOperation
  {
  public:
    FilterOperation();
    FilterOperation(Aws::Utils::Json::JsonView jsonValue);
    FilterOperation& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>An expression that must evaluate to a Boolean value. Rows for which the
     * expression evaluates to true are kept in the dataset.</p>
     */
    inline const Aws::String& GetConditionExpression() const{ return m_conditionExpression; }

    /**
     * <p>An expression that must evaluate to a Boolean value. Rows for which the
     * expression evaluates to true are kept in the dataset.</p>
     */
    inline bool ConditionExpressionHasBeenSet() const { return m_conditionExpressionHasBeenSet; }

    /**
     * <p>An expression that must evaluate to a Boolean value. Rows for which the
     * expression evaluates to true are kept in the dataset.</p>
     */
    inline void SetConditionExpression(const Aws::String& value) { m_conditionExpressionHasBeenSet = true; m_conditionExpression = value; }

    /**
     * <p>An expression that must evaluate to a Boolean value. Rows for which the
     * expression evaluates to true are kept in the dataset.</p>
     */
    inline void SetConditionExpression(Aws::String&& value) { m_conditionExpressionHasBeenSet = true; m_conditionExpression = std::move(value); }

    /**
     * <p>An expression that must evaluate to a Boolean value. Rows for which the
     * expression evaluates to true are kept in the dataset.</p>
     */
    inline void SetConditionExpression(const char* value) { m_conditionExpressionHasBeenSet = true; m_conditionExpression.assign(value); }

    /**
     * <p>An expression that must evaluate to a Boolean value. Rows for which the
     * expression evaluates to true are kept in the dataset.</p>
     */
    inline FilterOperation& WithConditionExpression(const Aws::String& value) { SetConditionExpression(value); return *this;}

    /**
     * <p>An expression that must evaluate to a Boolean value. Rows for which the
     * expression evaluates to true are kept in the dataset.</p>
     */
    inline FilterOperation& WithConditionExpression(Aws::String&& value) { SetConditionExpression(std::move(value)); return *this;}

    /**
     * <p>An expression that must evaluate to a Boolean value. Rows for which the
     * expression evaluates to true are kept in the dataset.</p>
     */
    inline FilterOperation& WithConditionExpression(const char* value) { SetConditionExpression(value); return *this;}

  private:

    Aws::String m_conditionExpression;
    bool m_conditionExpressionHasBeenSet;
  };

} // namespace Model
} // namespace QuickSight
} // namespace Aws
