/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.concurrent.atomic.AtomicLong;

public final class UniqueIdGenerator {
    private final AtomicLong idCounter = new AtomicLong(0L);

    long generateUniqueId() {
        return this.idCounter.decrementAndGet();
    }

    public long currentUniqueId() {
        return this.idCounter.get();
    }

    public void advanceUniqueId(long newId) {
        if (newId > this.currentUniqueId()) {
            throw new IllegalArgumentException("Cannot modify the id counter backwards");
        }
        this.idCounter.set(newId);
    }
}

