/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.gui.dialogs.properties.CopyAllKeyValueAction;
import org.openstreetmap.josm.gui.dialogs.properties.CopyKeyValueAction;
import org.openstreetmap.josm.gui.dialogs.properties.CopyValueAction;
import org.openstreetmap.josm.gui.dialogs.properties.HelpTagAction;
import org.openstreetmap.josm.gui.dialogs.properties.TaginfoAction;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryViewerPanel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TagInfoTransferHandler;
import org.openstreetmap.josm.gui.history.TagTableColumnModel;
import org.openstreetmap.josm.gui.history.TagTableModel;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;

public class TagInfoViewer
extends HistoryViewerPanel {
    public TagInfoViewer(HistoryBrowserModel model) {
        super(model);
    }

    @Override
    protected JTable buildTable(PointInTimeType pointInTime) {
        TagTableModel tagTableModel = this.model.getTagTableModel(pointInTime);
        JTable table = new JTable(tagTableModel, new TagTableColumnModel());
        table.setSelectionMode(2);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        table.setTransferHandler(new TagInfoTransferHandler());
        table.addFocusListener(new RepaintOnFocusChange());
        JPopupMenu tagMenu = new JPopupMenu();
        IntFunction<String> tagKeyFn = x -> (String)table.getValueAt(x, 0);
        IntFunction<Map<String, Integer>> tagValuesFn = x -> {
            String key = tagTableModel.getValue((String)table.getValueAt(x, 0));
            if (key != null) {
                return Collections.singletonMap(key, 1);
            }
            return Collections.emptyMap();
        };
        Supplier<Collection<? extends Tagged>> objectSp = () -> Collections.singletonList(this.model.getPointInTime(pointInTime));
        tagMenu.add(this.trackJosmAction(new CopyValueAction(table, tagKeyFn, objectSp)));
        CopyKeyValueAction copyKeyValueAction = new CopyKeyValueAction(table, tagKeyFn, objectSp);
        tagMenu.add(this.trackJosmAction(copyKeyValueAction));
        tagMenu.addPopupMenuListener(copyKeyValueAction);
        tagMenu.add(this.trackJosmAction(new CopyAllKeyValueAction(table, tagKeyFn, objectSp)));
        tagMenu.addSeparator();
        tagMenu.add(this.trackJosmAction(new HelpTagAction(table, tagKeyFn, tagValuesFn)));
        tagMenu.add(this.trackJosmAction(new TaginfoAction(table, tagKeyFn, tagValuesFn, null, null)));
        table.addMouseListener(new PopupMenuLauncher(tagMenu));
        return table;
    }

    private static final class RepaintOnFocusChange
    implements FocusListener {
        private RepaintOnFocusChange() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            RepaintOnFocusChange.repaintSelected(e);
        }

        @Override
        public void focusGained(FocusEvent e) {
            RepaintOnFocusChange.repaintSelected(e);
        }

        private static void repaintSelected(FocusEvent e) {
            e.getComponent().repaint();
        }
    }
}

