/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.net.URL;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.Logging;

public final class NetworkManager {
    private static final Map<String, Throwable> NETWORK_ERRORS = new HashMap<String, Throwable>();
    private static final Set<OnlineResource> OFFLINE_RESOURCES = EnumSet.noneOf(OnlineResource.class);

    private NetworkManager() {
    }

    public static Throwable addNetworkError(String url, Throwable t) {
        if (url != null && t != null) {
            return NETWORK_ERRORS.put(url, t);
        }
        return null;
    }

    public static Throwable addNetworkError(URL url, Throwable t) {
        if (url != null && t != null) {
            Throwable old = NetworkManager.addNetworkError(url.toExternalForm(), t);
            if (old != null) {
                Logging.warn("Already here " + old);
            }
            return old;
        }
        return null;
    }

    public static Map<String, Throwable> getNetworkErrors() {
        return new HashMap<String, Throwable>(NETWORK_ERRORS);
    }

    public static void clearNetworkErrors() {
        NETWORK_ERRORS.clear();
    }

    public static boolean isOffline(OnlineResource r) {
        return OFFLINE_RESOURCES.contains((Object)r) || OFFLINE_RESOURCES.contains((Object)OnlineResource.ALL);
    }

    public static boolean setOffline(OnlineResource r) {
        return OFFLINE_RESOURCES.add(r);
    }

    public static boolean setOnline(OnlineResource r) {
        return OFFLINE_RESOURCES.remove((Object)r);
    }

    public static Set<OnlineResource> getOfflineResources() {
        return EnumSet.copyOf(OFFLINE_RESOURCES);
    }
}

